/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.api.redstone;

import com.Da_Technomancer.essentials.ESConfig;
import com.Da_Technomancer.essentials.Essentials;
import com.Da_Technomancer.essentials.api.BlockUtil;
import com.Da_Technomancer.essentials.api.redstone.IReadable;
import com.Da_Technomancer.essentials.api.redstone.IRedstoneHandler;
import com.Da_Technomancer.essentials.api.redstone.IWireConnect;
import com.Da_Technomancer.essentials.items.CircuitWrench;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.registries.ForgeRegistries;

@ParametersAreNonnullByDefault
public class RedstoneUtil
extends BlockUtil {
    public static final Capability<IRedstoneHandler> REDSTONE_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IRedstoneHandler>(){});
    public static final Map<ResourceLocation, IReadable> READABLES = new HashMap<ResourceLocation, IReadable>();
    public static final float MAX_POWER = 1.0E9f;
    public static final float MIN_POWER = -1.0E9f;
    public static final int DELAY = 2;

    public static void registerReadable(Block block, IReadable readable) {
        ResourceLocation blockRegName = ForgeRegistries.BLOCKS.getKey((Object)block);
        if (!READABLES.containsKey(blockRegName) && !(block instanceof IReadable)) {
            READABLES.put(blockRegName, readable);
        } else {
            Essentials.logger.warn("Redundant readable handler registration: " + blockRegName);
        }
    }

    public static void registerCircuit(@Nonnull IWireConnect toRegister, @Nullable ResourceLocation icon) {
        if (!CircuitWrench.MODES.contains(toRegister)) {
            CircuitWrench.MODES.add(toRegister);
            CircuitWrench.ICONS.add(icon);
        } else {
            Essentials.logger.warn("Redundant circuit registration: " + ForgeRegistries.BLOCKS.getKey((Object)toRegister.wireAsBlock()));
        }
    }

    @Nullable
    public static IReadable getReadable(Block block) {
        if (block instanceof IReadable) {
            return (IReadable)block;
        }
        return READABLES.get(ForgeRegistries.BLOCKS.getKey((Object)block));
    }

    public static int getMaxRange() {
        return (Integer)ESConfig.maxRedstoneRange.get();
    }

    public static float sanitize(float input) {
        if (Float.isNaN(input)) {
            return 0.0f;
        }
        if (input >= 1.0E9f) {
            return 1.0E9f;
        }
        if (input <= -1.0E9f) {
            return -1.0E9f;
        }
        return input;
    }

    public static int clampToVanilla(float input) {
        if ((input = RedstoneUtil.sanitize(input)) > 15.0f) {
            return 15;
        }
        if (input < 0.0f) {
            return 0;
        }
        return Math.round(input);
    }

    public static boolean didChange(float prevVal, float newVal) {
        return Math.signum(newVal) != Math.signum(prevVal) || newVal != 0.0f && (double)(Math.abs(newVal - prevVal) / Math.abs(newVal)) > 5.0E-5;
    }

    public static int getRedstoneOnSide(Level w, BlockPos pos, Direction dir) {
        BlockPos offsetPos = pos.m_121945_(dir);
        BlockState state = w.m_8055_(offsetPos);
        return Math.min(15, state.m_60734_() == Blocks.f_50088_ ? ((Integer)state.m_61143_((Property)RedStoneWireBlock.f_55500_)).intValue() : w.m_277185_(offsetPos, dir));
    }

    public static int getRedstoneAtPos(Level w, BlockPos pos) {
        int val = 0;
        for (Direction dir : Direction.values()) {
            val = Math.max(val, RedstoneUtil.getRedstoneOnSide(w, pos, dir));
        }
        return val;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static float interpretFormulaString(String input) {
        ArrayList<Constable> formula;
        boolean working;
        float output;
        block30: {
            output = 0.0f;
            working = true;
            formula = new ArrayList<Constable>();
            String opChars = "+-xX*/()^";
            int index = 0;
            while (index < input.length()) {
                int subInd;
                for (subInd = index; subInd < input.length() && (Character.isDigit(input.charAt(subInd)) || input.charAt(subInd) == '.'); ++subInd) {
                }
                if (index < subInd) {
                    try {
                        float val = Float.parseFloat(input.substring(index, subInd));
                        formula.add(Float.valueOf(val));
                        index = subInd;
                        continue;
                    }
                    catch (NumberFormatException e) {
                        working = false;
                        break;
                    }
                }
                if (input.charAt(index) == 'e') {
                    formula.add(Float.valueOf((float)Math.E));
                    ++index;
                    continue;
                }
                if (input.length() > index + 1 && input.substring(index, index + 2).toLowerCase().equals("pi")) {
                    formula.add(Float.valueOf((float)Math.PI));
                    index += 2;
                    continue;
                }
                if ("+-xX*/()^".contains(input.substring(index, index + 1))) {
                    char c = input.charAt(index);
                    formula.add(Character.valueOf(c == 'x' || c == 'X' ? (char)'*' : input.charAt(index)));
                    ++index;
                    continue;
                }
                if (input.charAt(index) == 'E') {
                    formula.add(Character.valueOf('*'));
                    formula.add(Float.valueOf(10.0f));
                    formula.add(Character.valueOf('^'));
                    ++index;
                    continue;
                }
                if (input.charAt(index) == ' ') {
                    ++index;
                    continue;
                }
                working = false;
                break;
            }
            if (!working) break block30;
            int openParens = 0;
            boolean prevNumb = false;
            boolean prevReqNextNumber = false;
            boolean bl = false;
            for (Object e : formula) {
                boolean bl2;
                boolean numberFromRight;
                boolean numberFromLeft;
                block29: {
                    block31: {
                        numberFromLeft = false;
                        numberFromRight = false;
                        if (!(e instanceof Character)) break block31;
                        switch (((Character)e).charValue()) {
                            case '(': {
                                ++openParens;
                                numberFromLeft = true;
                                break block29;
                            }
                            case ')': {
                                if (openParens == 0) {
                                    working = false;
                                    break;
                                }
                                --openParens;
                                numberFromRight = true;
                                break block29;
                            }
                            case '*': 
                            case '+': 
                            case '/': 
                            case '^': {
                                if (prevNumb) {
                                    bl2 = true;
                                    break block29;
                                } else {
                                    working = false;
                                    break;
                                }
                            }
                            case '-': {
                                numberFromLeft = true;
                                bl2 = true;
                                break block29;
                            }
                            default: {
                                Essentials.logger.warn("Invalid formula state! Report to mod author, and give them this: " + input);
                                working = false;
                                break;
                            }
                        }
                        break;
                    }
                    if (e instanceof Float) {
                        numberFromLeft = true;
                        numberFromRight = true;
                    } else {
                        Essentials.logger.warn("Invalid formula state! Report to mod author, and give them this: " + input);
                        working = false;
                        break;
                    }
                }
                if (prevReqNextNumber && !numberFromLeft) {
                    working = false;
                    break;
                }
                prevNumb = numberFromRight;
                prevReqNextNumber = bl2;
                bl2 = false;
            }
            if (prevReqNextNumber) {
                working = false;
            }
            for (int i = 0; i < openParens; ++i) {
                formula.add(Character.valueOf(')'));
            }
        }
        if (!working) return output;
        ArrayList<Object> formulaActive = new ArrayList<Object>(formula.size());
        formulaActive.addAll(formula);
        try {
            float value = RedstoneUtil.operate(formulaActive);
            if (Float.isNaN(value)) {
                return 0.0f;
            }
            if (!Float.isInfinite(value)) return value;
            return Math.copySign(Float.MAX_VALUE, value);
        }
        catch (Exception e) {
            Essentials.logger.warn("Error interpreting formula; Report to mod author");
            e.printStackTrace();
            Essentials.logger.warn("Full formula data: [" + input + "]");
            Essentials.logger.warn("Parsed formula: ");
            Iterator iterator = formula.iterator();
            while (iterator.hasNext()) {
                Object e2 = iterator.next();
                Essentials.logger.warn("\tFormula item: " + e2.toString());
            }
            return 0.0f;
        }
    }

    private static float operate(ArrayList<Object> formula) {
        if (formula.size() == 0) {
            return 0.0f;
        }
        while (formula.size() > 1) {
            int i;
            int openParenIndex = formula.indexOf(Character.valueOf('('));
            if (openParenIndex != -1) {
                int openParens = 1;
                int closeParenIndex = openParenIndex;
                while (openParens != 0 && closeParenIndex < formula.size() - 1) {
                    Object o;
                    if (!((o = formula.get(++closeParenIndex)) instanceof Character)) continue;
                    if (((Character)o).charValue() == '(') {
                        ++openParens;
                        continue;
                    }
                    if (((Character)o).charValue() != ')') continue;
                    --openParens;
                }
                ArrayList<Object> subForm = new ArrayList<Object>(closeParenIndex - openParenIndex - 1);
                formula.remove(openParenIndex);
                for (i = openParenIndex; i < closeParenIndex - 1; ++i) {
                    subForm.add(formula.get(openParenIndex));
                    formula.remove(openParenIndex);
                }
                formula.remove(openParenIndex);
                formula.add(openParenIndex, Float.valueOf(RedstoneUtil.operate(subForm)));
                continue;
            }
            int expIndex = formula.indexOf(Character.valueOf('^'));
            if (expIndex != -1) {
                expIndex = RedstoneUtil.checkForNeg(formula, expIndex);
                float prev = ((Float)formula.get(expIndex - 1)).floatValue();
                float next = ((Float)formula.get(expIndex + 1)).floatValue();
                formula.remove(expIndex - 1);
                formula.remove(expIndex - 1);
                formula.remove(expIndex - 1);
                formula.add(expIndex - 1, Float.valueOf((float)Math.pow(prev, next)));
                continue;
            }
            int multIndex = formula.indexOf(Character.valueOf('*'));
            if (multIndex != -1) {
                multIndex = RedstoneUtil.checkForNeg(formula, multIndex);
                float prev = ((Float)formula.get(multIndex - 1)).floatValue();
                float next = ((Float)formula.get(multIndex + 1)).floatValue();
                formula.remove(multIndex - 1);
                formula.remove(multIndex - 1);
                formula.remove(multIndex - 1);
                formula.add(multIndex - 1, Float.valueOf(prev * next));
                continue;
            }
            boolean didMult = false;
            for (i = 0; i < formula.size() - 1; ++i) {
                Object o = formula.get(i);
                Object o1 = formula.get(i + 1);
                if (!(o instanceof Float) || !(o1 instanceof Float)) continue;
                formula.remove(i);
                formula.remove(i);
                formula.add(i, Float.valueOf(((Float)o).floatValue() * ((Float)o1).floatValue()));
                didMult = true;
                break;
            }
            if (didMult) continue;
            int divIndex = formula.indexOf(Character.valueOf('/'));
            if (divIndex != -1) {
                divIndex = RedstoneUtil.checkForNeg(formula, divIndex);
                float prev = ((Float)formula.get(divIndex - 1)).floatValue();
                float next = ((Float)formula.get(divIndex + 1)).floatValue();
                formula.remove(divIndex - 1);
                formula.remove(divIndex - 1);
                formula.remove(divIndex - 1);
                formula.add(divIndex - 1, Float.valueOf(prev / next));
                continue;
            }
            int sumIndex = formula.indexOf(Character.valueOf('+'));
            if (sumIndex != -1) {
                sumIndex = RedstoneUtil.checkForNeg(formula, sumIndex);
                float prev = ((Float)formula.get(sumIndex - 1)).floatValue();
                float next = ((Float)formula.get(sumIndex + 1)).floatValue();
                formula.remove(sumIndex - 1);
                formula.remove(sumIndex - 1);
                formula.remove(sumIndex - 1);
                formula.add(sumIndex - 1, Float.valueOf(prev + next));
                continue;
            }
            int subIndex = formula.indexOf(Character.valueOf('-'));
            if (subIndex == -1) continue;
            if (subIndex == 0) {
                formula.remove(0);
                Object o = formula.get(0);
                formula.remove(0);
                formula.add(0, Float.valueOf(-((Float)o).floatValue()));
                continue;
            }
            subIndex = RedstoneUtil.checkForNeg(formula, subIndex);
            float prev = ((Float)formula.get(subIndex - 1)).floatValue();
            float next = ((Float)formula.get(subIndex + 1)).floatValue();
            formula.remove(subIndex - 1);
            formula.remove(subIndex - 1);
            formula.remove(subIndex - 1);
            formula.add(subIndex - 1, Float.valueOf(prev - next));
        }
        return ((Float)formula.get(0)).floatValue();
    }

    private static int checkForNeg(ArrayList<Object> formula, int opIndex) {
        Float o;
        if (formula.size() - opIndex > 2 && (o = RedstoneUtil.applyNeg(formula.get(opIndex + 1), formula.get(opIndex + 2))) != null) {
            formula.remove(opIndex + 1);
            formula.remove(opIndex + 1);
            formula.add(opIndex + 1, o);
        }
        if (opIndex > 1 && (o = RedstoneUtil.applyNeg(formula.get(opIndex - 2), formula.get(opIndex - 1))) != null) {
            formula.remove(--opIndex - 1);
            formula.remove(opIndex - 1);
            formula.add(opIndex - 1, o);
        }
        return opIndex;
    }

    private static Float applyNeg(Object item1, Object item2) {
        if (item1 instanceof Character && ((Character)item1).charValue() == '-') {
            return Float.valueOf(-1.0f * ((Float)item2).floatValue());
        }
        return null;
    }

    public static float chooseInput(float in0, float in1) {
        if (Math.abs(in0) < Math.abs(in1) || in0 == -in1 && in1 > 0.0f) {
            return in1;
        }
        return in0;
    }
}

