/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.api.packets;

import com.Da_Technomancer.essentials.Essentials;
import com.Da_Technomancer.essentials.api.packets.Packet;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class PacketManager {
    private static final HashMap<Class<?>, BiConsumer<Object, FriendlyByteBuf>> writeMap = new HashMap();
    private static final HashMap<Class<?>, Function<FriendlyByteBuf, Object>> readMap = new HashMap();

    public static void addCodec(Class<?> clazz, BiConsumer<Object, FriendlyByteBuf> writer, Function<FriendlyByteBuf, Object> reader) {
        writeMap.put(clazz, writer);
        readMap.put(clazz, reader);
    }

    public static <T extends Packet> void encode(T packet, FriendlyByteBuf buf) {
        Field[] toEncode;
        for (Field f : toEncode = packet.getFields()) {
            BiConsumer<Object, FriendlyByteBuf> writer = writeMap.get(f.getType());
            if (writer == null) {
                Essentials.logger.error("Failed to get writer for packet class. Report to mod author: " + f.getType().toString());
                continue;
            }
            try {
                writer.accept(f.get(packet), buf);
            }
            catch (ClassCastException | IllegalAccessException e) {
                Essentials.logger.error("Failed to encode packet class. Report to mod author: " + f.getType().toString(), (Throwable)e);
                throw new IllegalStateException();
            }
        }
    }

    public static <T extends Packet> T decode(FriendlyByteBuf buf, Class<T> clazz) {
        Field[] toDecode;
        Packet packet;
        try {
            packet = (Packet)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            Essentials.logger.error("Unable to instantiate packet. Report to mod author: " + clazz.toString(), (Throwable)e);
            throw new IllegalStateException();
        }
        for (Field f : toDecode = packet.getFields()) {
            Function<FriendlyByteBuf, Object> reader = readMap.get(f.getType());
            if (reader == null) {
                Essentials.logger.error("Failed to get reader for packet class. Report to mod author: " + f.getType().toString());
                throw new IllegalStateException();
            }
            try {
                f.set(packet, reader.apply(buf));
            }
            catch (ClassCastException | IllegalAccessException e) {
                Essentials.logger.error("Failed to decode packet class. Report to mod author: " + f.getType().toString(), (Throwable)e);
                throw new IllegalStateException();
            }
        }
        return (T)packet;
    }

    public static <T extends Packet> void activate(T packet, Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context cont = context.get();
        packet.consume(cont);
        cont.setPacketHandled(true);
    }

    private static String readString(FriendlyByteBuf buf) {
        return buf.m_130136_(Short.MAX_VALUE);
    }

    static {
        PacketManager.addCodec(Boolean.TYPE, (val, buf) -> buf.writeBoolean(((Boolean)val).booleanValue()), FriendlyByteBuf::readBoolean);
        PacketManager.addCodec(Boolean.class, (val, buf) -> buf.writeBoolean(((Boolean)val).booleanValue()), FriendlyByteBuf::readBoolean);
        PacketManager.addCodec(Byte.TYPE, (val, buf) -> buf.writeByte((int)((Byte)val).byteValue()), FriendlyByteBuf::readByte);
        PacketManager.addCodec(Byte.class, (val, buf) -> buf.writeByte((int)((Byte)val).byteValue()), FriendlyByteBuf::readByte);
        PacketManager.addCodec(Integer.TYPE, (val, buf) -> buf.writeInt(((Integer)val).intValue()), FriendlyByteBuf::readInt);
        PacketManager.addCodec(Integer.class, (val, buf) -> buf.writeInt(((Integer)val).intValue()), FriendlyByteBuf::readInt);
        PacketManager.addCodec(Long.TYPE, (val, buf) -> buf.writeLong(((Long)val).longValue()), FriendlyByteBuf::readLong);
        PacketManager.addCodec(Long.class, (val, buf) -> buf.writeLong(((Long)val).longValue()), FriendlyByteBuf::readLong);
        PacketManager.addCodec(Float.TYPE, (val, buf) -> buf.writeFloat(((Float)val).floatValue()), FriendlyByteBuf::readFloat);
        PacketManager.addCodec(Float.class, (val, buf) -> buf.writeFloat(((Float)val).floatValue()), FriendlyByteBuf::readFloat);
        PacketManager.addCodec(Double.TYPE, (val, buf) -> buf.writeDouble(((Double)val).doubleValue()), FriendlyByteBuf::readDouble);
        PacketManager.addCodec(Double.class, (val, buf) -> buf.writeDouble(((Double)val).doubleValue()), FriendlyByteBuf::readDouble);
        PacketManager.addCodec(String.class, (val, buf) -> buf.m_130070_((String)val), PacketManager::readString);
        PacketManager.addCodec(BlockPos.class, (val, buf) -> buf.m_130064_((BlockPos)val), FriendlyByteBuf::m_130135_);
        PacketManager.addCodec(CompoundTag.class, (val, buf) -> buf.m_130079_((CompoundTag)val), FriendlyByteBuf::m_130260_);
        PacketManager.addCodec(byte[].class, (val, buf) -> buf.m_130087_((byte[])val), FriendlyByteBuf::m_130052_);
    }
}

