/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.api;

import com.Da_Technomancer.essentials.api.BlockUtil;
import com.Da_Technomancer.essentials.api.ILinkTE;
import com.Da_Technomancer.essentials.api.RenderUtil;
import com.Da_Technomancer.essentials.api.packets.SendLongToClient;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.apache.commons.lang3.tuple.Pair;

public class LinkHelper {
    public static final TagKey<Item> LINKING_TOOLS = ItemTags.create((ResourceLocation)new ResourceLocation("essentials", "linking_tool"));
    public static final String POS_NBT = "c_link";
    public static final String DIM_NBT = "c_link_dim";
    public static final byte LINK_PACKET_ID = 8;
    public static final byte REMOVE_PACKET_ID = 10;
    private final Set<BlockPos> linked = new HashSet<BlockPos>();
    private final ILinkTE te;
    public static final ResourceLocation LINK_TEXTURE = new ResourceLocation("essentials", "textures/model/link_line.png");
    @OnlyIn(value=Dist.CLIENT)
    private static RenderType LINK_TYPE;

    public LinkHelper(ILinkTE te) {
        this.te = te;
    }

    public Set<BlockPos> getLinksRelative() {
        return this.linked;
    }

    public Iterable<BlockPos> getLinksAbsolute() {
        BlockPos selfPos = this.te.getTE().m_58899_();
        return this.linked.stream().map(relPos -> relPos.m_121955_((Vec3i)selfPos)).collect(Collectors.toList());
    }

    public void readNBT(CompoundTag nbt) {
        int i = 0;
        while (nbt.m_128441_("link_" + i)) {
            this.linked.add(BlockPos.m_122022_((long)nbt.m_128454_("link_" + i)));
            ++i;
        }
    }

    public void writeNBT(CompoundTag nbt) {
        int count = 0;
        for (BlockPos relPos : this.linked) {
            nbt.m_128356_("link_" + count++, relPos.m_121878_());
        }
    }

    public boolean addLink(ILinkTE endpoint, @Nullable Player player) {
        if (this.linked.size() >= this.te.getMaxLinks()) {
            return false;
        }
        BlockPos tePos = this.te.getTE().m_58899_();
        BlockPos linkPos = endpoint.getTE().m_58899_().m_121996_((Vec3i)tePos);
        this.linked.add(linkPos);
        BlockUtil.sendClientPacketAround(this.te.getTE().m_58904_(), tePos, new SendLongToClient(8, linkPos.m_121878_(), tePos));
        this.te.getTE().m_6596_();
        return true;
    }

    public void removeLink(BlockPos endpoint) {
        BlockPos tePos = this.te.getTE().m_58899_();
        this.linked.remove(endpoint);
        BlockUtil.sendClientPacketAround(this.te.getTE().m_58904_(), tePos, new SendLongToClient(10, endpoint.m_121878_(), tePos));
        this.te.getTE().m_6596_();
    }

    public void unlinkAllEndpoints() {
        BlockPos selfPos = this.te.getTE().m_58899_();
        Level world = this.te.getTE().m_58904_();
        HashSet<BlockPos> linkedCopy = new HashSet<BlockPos>(this.linked);
        this.linked.clear();
        for (BlockPos relPos : linkedCopy) {
            BlockPos endPos = relPos.m_121955_((Vec3i)selfPos);
            BlockEntity endTe = world.m_7702_(endPos);
            if (!(endTe instanceof ILinkTE)) continue;
            ((ILinkTE)endTe).removeLinkEnd(selfPos);
        }
    }

    public boolean handleIncomingPacket(byte discriminator, long message) {
        if (discriminator == 8) {
            this.linked.add(BlockPos.m_122022_((long)message));
            return true;
        }
        if (discriminator == 10) {
            this.linked.remove(BlockPos.m_122022_((long)message));
            return true;
        }
        return false;
    }

    public AABB frustrum() {
        BlockPos pos = this.te.getTE().m_58899_();
        int[] min = new int[3];
        int[] max = new int[3];
        for (BlockPos link : this.te.getLinks()) {
            min[0] = Math.min(min[0], link.m_123341_());
            min[1] = Math.min(min[1], link.m_123342_());
            min[2] = Math.min(min[2], link.m_123343_());
            max[0] = Math.max(max[0], link.m_123341_());
            max[1] = Math.max(max[1], link.m_123342_());
            max[2] = Math.max(max[2], link.m_123343_());
        }
        return new AABB((double)(min[0] + pos.m_123341_()), (double)(min[1] + pos.m_123342_()), (double)(min[2] + pos.m_123343_()), (double)(max[0] + pos.m_123341_() + 1), (double)(max[1] + pos.m_123342_() + 1), (double)(max[2] + pos.m_123343_() + 1));
    }

    public static boolean isLinkTool(ItemStack stack) {
        return stack.m_204117_(LINKING_TOOLS);
    }

    public static ItemStack wrench(ILinkTE linkTE, ItemStack wrench, Player player) {
        if (player.m_6047_()) {
            player.m_5661_((Component)Component.m_237115_((String)"tt.essentials.linking.clear"), true);
            ArrayList<BlockPos> links = new ArrayList<BlockPos>(linkTE.getLinks());
            Level world = linkTE.getTE().m_58904_();
            BlockPos srcPos = linkTE.getTE().m_58899_();
            for (BlockPos link : links) {
                linkTE.removeLinkSource(link);
                BlockEntity endTE = world.m_7702_(srcPos.m_121955_((Vec3i)link));
                if (!(endTE instanceof ILinkTE)) continue;
                ((ILinkTE)endTE).removeLinkEnd(srcPos);
            }
            LinkHelper.clearLinkNBT(wrench);
            return wrench;
        }
        Pair<String, BlockPos> wrenchData = LinkHelper.readLinkNBT(wrench);
        if (wrenchData != null && ((String)wrenchData.getLeft()).equals(LinkHelper.getWorldString(player.m_9236_()))) {
            BlockEntity prevTE = player.m_9236_().m_7702_((BlockPos)wrenchData.getRight());
            if (prevTE instanceof ILinkTE && ((ILinkTE)prevTE).canLink(linkTE) && prevTE != linkTE) {
                int range = ((ILinkTE)prevTE).getRange();
                if (((BlockPos)wrenchData.getRight()).m_123331_((Vec3i)linkTE.getTE().m_58899_()) <= (double)(range * range)) {
                    ILinkTE prevLinkTe = (ILinkTE)prevTE;
                    BlockPos relLinkPos = linkTE.getTE().m_58899_().m_121996_((Vec3i)prevTE.m_58899_());
                    if (prevLinkTe.getLinks().contains(relLinkPos)) {
                        prevLinkTe.removeLinkSource(relLinkPos);
                        linkTE.removeLinkEnd(prevTE.m_58899_());
                        player.m_5661_((Component)Component.m_237110_((String)"tt.essentials.linking.remove", (Object[])new Object[]{prevTE.m_58899_(), linkTE.getTE().m_58899_()}), true);
                    } else if (prevLinkTe.getLinks().size() < prevLinkTe.getMaxLinks()) {
                        if (prevLinkTe.createLinkSource(linkTE, player)) {
                            linkTE.createLinkEnd(prevLinkTe);
                            player.m_5661_((Component)Component.m_237110_((String)"tt.essentials.linking.success", (Object[])new Object[]{prevTE.m_58899_(), linkTE.getTE().m_58899_()}), true);
                        }
                    } else {
                        player.m_5661_((Component)Component.m_237110_((String)"tt.essentials.linking.full", (Object[])new Object[]{prevLinkTe.getMaxLinks()}), true);
                    }
                } else {
                    player.m_5661_((Component)Component.m_237115_((String)"tt.essentials.linking.range"), true);
                }
                LinkHelper.clearLinkNBT(wrench);
                return wrench;
            }
            player.m_5661_((Component)Component.m_237115_((String)"tt.essentials.linking.invalid"), true);
        } else if (linkTE.canBeginLinking()) {
            LinkHelper.setLinkNBT(wrench, linkTE.getTE().m_58899_(), LinkHelper.getWorldString(linkTE.getTE().m_58904_()));
            player.m_5661_((Component)Component.m_237115_((String)"tt.essentials.linking.start"), true);
            return wrench;
        }
        LinkHelper.clearLinkNBT(wrench);
        return wrench;
    }

    private static String getWorldString(Level world) {
        return world.m_46472_().m_135782_().toString();
    }

    private static void setLinkNBT(ItemStack linkingTool, BlockPos targetPos, String targetWorld) {
        CompoundTag itemNBT = linkingTool.m_41784_();
        itemNBT.m_128356_(POS_NBT, targetPos.m_121878_());
        itemNBT.m_128359_(DIM_NBT, targetWorld);
    }

    private static void clearLinkNBT(ItemStack linkingTool) {
        CompoundTag itemNBT = linkingTool.m_41783_();
        if (itemNBT != null) {
            itemNBT.m_128473_(POS_NBT);
            itemNBT.m_128473_(DIM_NBT);
        }
    }

    @Nullable
    private static Pair<String, BlockPos> readLinkNBT(ItemStack linkingTool) {
        CompoundTag itemNBT = linkingTool.m_41783_();
        if (itemNBT == null) {
            return null;
        }
        if (itemNBT.m_128441_(POS_NBT) && itemNBT.m_128441_(DIM_NBT)) {
            return Pair.of((Object)itemNBT.m_128461_(DIM_NBT), (Object)BlockPos.m_122022_((long)itemNBT.m_128454_(POS_NBT)));
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static RenderType getLinkRenderType() {
        return LINK_TYPE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderLinkLineToPoint(Vec3 startPoint, Vec3 ray, Color linkCol, float partialTicks, PoseStack matrix, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        float alpha = 0.7f;
        int[] col = new int[]{linkCol.getRed(), linkCol.getGreen(), linkCol.getBlue(), (int)(alpha * 255.0f)};
        float uWidth = 0.33333334f;
        Vec3 widthVec = RenderUtil.findRayWidth(startPoint, ray, 0.3f);
        Vec3 normal = ray.m_82537_(widthVec);
        float length = (float)ray.m_82553_();
        VertexConsumer builder = buffer.m_6299_(LinkHelper.getLinkRenderType());
        RenderUtil.addVertexBlock(builder, matrix, (Position)widthVec.m_82490_(-1.0), 0.0f, 0.0f, (Position)normal, alpha, 0xF000F0);
        RenderUtil.addVertexBlock(builder, matrix, (Position)widthVec, uWidth, 0.0f, (Position)normal, alpha, 0xF000F0);
        RenderUtil.addVertexBlock(builder, matrix, (Position)ray.m_82549_(widthVec), uWidth, length / 3.0f, (Position)normal, alpha, 0xF000F0);
        RenderUtil.addVertexBlock(builder, matrix, (Position)ray.m_82546_(widthVec), 0.0f, length / 3.0f, (Position)normal, alpha, 0xF000F0);
        RenderUtil.addVertexBlock(builder, matrix, (Position)widthVec.m_82490_(-1.0), uWidth, 0.0f, (Position)normal, 0xF000F0, col);
        RenderUtil.addVertexBlock(builder, matrix, (Position)widthVec, uWidth * 2.0f, 0.0f, (Position)normal, 0xF000F0, col);
        RenderUtil.addVertexBlock(builder, matrix, (Position)ray.m_82549_(widthVec), uWidth * 2.0f, length / 3.0f, (Position)normal, 0xF000F0, col);
        RenderUtil.addVertexBlock(builder, matrix, (Position)ray.m_82546_(widthVec), uWidth, length / 3.0f, (Position)normal, 0xF000F0, col);
    }

    static {
        if (FMLEnvironment.dist == Dist.CLIENT) {
            LINK_TYPE = DummyRenderType.initType();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class DummyRenderType
    extends RenderType {
        private DummyRenderType(String p_i225992_1_, VertexFormat p_i225992_2_, VertexFormat.Mode p_i225992_3_, int p_i225992_4_, boolean p_i225992_5_, boolean p_i225992_6_, Runnable p_i225992_7_, Runnable p_i225992_8_) {
            super(p_i225992_1_, p_i225992_2_, p_i225992_3_, p_i225992_4_, p_i225992_5_, p_i225992_6_, p_i225992_7_, p_i225992_8_);
        }

        private static RenderType initType() {
            return RenderType.m_173215_((String)"link_line", (VertexFormat)DefaultVertexFormat.f_85811_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RenderStateShard.f_173105_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(LINK_TEXTURE, false, false)).m_110685_(RenderStateShard.f_110139_).m_110691_(false));
        }
    }
}

