/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.api;

import com.Da_Technomancer.essentials.ESConfig;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.ToolAction;

public class ConfigUtil {
    public static final Style TT_QUIP = Style.f_131099_.m_131157_(ChatFormatting.AQUA).m_131155_(Boolean.valueOf(true));
    public static final ToolAction WRENCH_ACTION = ToolAction.get((String)"wrench");
    private static final TagKey<Item> WRENCH = ItemTags.create((ResourceLocation)new ResourceLocation("forge:tools/wrench"));
    private static final NumberFormat scientific = new DecimalFormat("0.###E0");
    private static final NumberFormat engineering = new DecimalFormat("##0.###E0");

    public static boolean isWrench(ItemStack stack) {
        return stack.m_204117_(WRENCH) || stack.canPerformAction(WRENCH_ACTION);
    }

    public static String formatFloat(float value, @Nullable NumberTypes format) {
        if (format == null) {
            format = (NumberTypes)((Object)ESConfig.numberDisplay.get());
        }
        switch (format) {
            case SCIENTIFIC: {
                float absValue = Math.abs(value);
                if (absValue == 0.0f) {
                    return "0";
                }
                if (absValue < 1000000.0f && absValue >= 0.001f) {
                    return ConfigUtil.trimTrail((float)Math.round(value * 1000.0f) / 1000.0f);
                }
                return scientific.format(value);
            }
            case ENGINEERING: {
                float absoValue = Math.abs(value);
                if (absoValue == 0.0f) {
                    return "0";
                }
                if (absoValue < 1000.0f && absoValue >= 0.001f) {
                    return ConfigUtil.trimTrail((float)Math.round(value * 1000.0f) / 1000.0f);
                }
                return engineering.format(value);
            }
            case HEX: {
                return Float.toHexString(value);
            }
        }
        return Float.toString(value);
    }

    private static String trimTrail(float valFloat) {
        String val = Float.toString(valFloat);
        while (val.contains(".") && (val.endsWith("0") || val.endsWith("."))) {
            val = val.substring(0, val.length() - 2);
        }
        return val;
    }

    public static enum NumberTypes {
        NORMAL,
        SCIENTIFIC,
        ENGINEERING,
        HEX;

    }
}

