/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.api;

import com.Da_Technomancer.essentials.Essentials;
import com.Da_Technomancer.essentials.api.packets.EssentialsPackets;
import com.Da_Technomancer.essentials.api.packets.Packet;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.network.PacketDistributor;

public class BlockUtil {
    public static <T> T get(@Nullable LazyOptional<T> optional) {
        return (T)(optional != null && optional.isPresent() ? optional.orElseThrow(NullPointerException::new) : null);
    }

    public static void sendClientPacketAround(Level world, BlockPos pos, Packet packet) {
        EssentialsPackets.channel.send(PacketDistributor.NEAR.with(PacketDistributor.TargetPoint.p((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (double)512.0, (ResourceKey)world.m_46472_())), (Object)packet);
    }

    public static boolean sameItem(ItemStack a, ItemStack b) {
        if (a == null || b == null) {
            return false;
        }
        return ItemStack.m_150942_((ItemStack)a, (ItemStack)b);
    }

    public static boolean sameFluid(FluidStack a, FluidStack b) {
        if (a == null || b == null) {
            return false;
        }
        return a.getFluid() == b.getFluid() && FluidStack.areFluidStackTagsEqual((FluidStack)a, (FluidStack)b);
    }

    @Deprecated
    public static Collection<BlockEntity> getAllLoadedBlockEntitiesRange(Level world, BlockPos centerPos, int range) {
        ArrayList<BlockEntity> blockEntities = new ArrayList<BlockEntity>();
        int minChunkX = SectionPos.m_123171_((int)(centerPos.m_123341_() - range));
        int minChunkZ = SectionPos.m_123171_((int)(centerPos.m_123343_() - range));
        int maxChunkX = SectionPos.m_123171_((int)(centerPos.m_123341_() + range));
        int maxChunkZ = SectionPos.m_123171_((int)(centerPos.m_123343_() + range));
        for (int i = minChunkX; i <= maxChunkX; ++i) {
            for (int j = minChunkZ; j <= maxChunkZ; ++j) {
                BlockPos internalPos = new BlockPos(SectionPos.m_123223_((int)i), centerPos.m_123342_(), SectionPos.m_123223_((int)j));
                try {
                    if (!world.m_46749_(internalPos)) continue;
                    LevelChunk chunk = world.m_6325_(i, j);
                    blockEntities.addAll(chunk.m_62954_().values());
                    continue;
                }
                catch (IllegalStateException e) {
                    Essentials.logger.catching((Throwable)e);
                }
            }
        }
        return blockEntities;
    }
}

