/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.api;

import com.Da_Technomancer.essentials.Essentials;
import com.Da_Technomancer.essentials.api.IItemContainer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public abstract class BlockMenuContainer<U extends BlockEntity>
extends AbstractContainerMenu {
    protected final Container playerInv;
    protected final U te;

    public BlockMenuContainer(MenuType<? extends AbstractContainerMenu> type, int windowId, Inventory playerInv, FriendlyByteBuf data) {
        super(type, windowId);
        this.playerInv = playerInv;
        BlockPos pos = data.m_130135_();
        BlockEntity rawTE = playerInv.f_35978_.m_9236_().m_7702_(pos);
        Object worldTe = null;
        if (rawTE != null) {
            try {
                worldTe = rawTE;
            }
            catch (ClassCastException e) {
                Essentials.logger.error("UI opened without TE in world!");
            }
        } else {
            Essentials.logger.error("Null TileEntity passed to TileEntityContainer!");
        }
        if (worldTe == null) {
            worldTe = this.generateEmptyTE(pos, playerInv.f_35978_.m_9236_().m_8055_(pos));
            worldTe.m_142339_(playerInv.f_35978_.m_9236_());
            Essentials.logger.error("Null world tile entity! Generating dummy TE. Report to mod author; type=%1$s", (Object)type.toString());
        }
        this.te = worldTe;
        this.addSlots();
        int[] invStart = this.getInvStart();
        for (int x = 0; x < 9; ++x) {
            this.m_38897_(new Slot((Container)playerInv, x, invStart[0] + x * 18, invStart[1] + 58));
        }
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.m_38897_(new Slot((Container)playerInv, x + y * 9 + 9, invStart[0] + x * 18, invStart[1] + y * 18));
            }
        }
    }

    protected U generateEmptyTE(BlockPos pos, BlockState state) {
        BlockEntity created;
        try {
            Class clazz = (Class)((ParameterizedType)((Object)((Object)this)).getClass().getGenericSuperclass()).getActualTypeArguments()[0];
            created = (BlockEntity)clazz.getConstructor(BlockPos.class, BlockState.class).newInstance(pos, state);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new NullPointerException("Could not instantiate fake TileEntity for TileEntityContainer! Report to mod author!");
        }
        return (U)created;
    }

    protected abstract void addSlots();

    protected abstract int slotCount();

    protected int[] getInvStart() {
        return new int[]{8, 84};
    }

    public ItemStack m_7648_(Player playerIn, int fromSlot) {
        ItemStack previous = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(fromSlot);
        if (slot != null && slot.m_6657_()) {
            ItemStack current = slot.m_7993_();
            previous = current.m_41777_();
            if (fromSlot < this.slotCount()) {
                if (!this.m_38903_(current, this.slotCount(), 36 + this.slotCount(), true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(current, previous);
            } else {
                if (!this.m_38903_(current, 0, this.slotCount(), false)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(current, previous);
            }
            if (current.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (current.m_41613_() == previous.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(playerIn, current);
        }
        return previous;
    }

    public boolean m_6875_(Player playerIn) {
        return ((Container)this.te).m_6542_(playerIn);
    }

    protected static class OutputSlot
    extends Slot {
        public OutputSlot(Container te, int index, int x, int y) {
            super(te, index, x, y);
        }

        public boolean m_5857_(ItemStack stack) {
            return false;
        }
    }

    protected static class StrictSlot
    extends Slot {
        public StrictSlot(Container te, int index, int x, int y) {
            super(te, index, x, y);
        }

        public boolean m_5857_(ItemStack stack) {
            return this.f_40218_.m_7013_(this.getSlotIndex(), stack);
        }

        public int m_6641_() {
            Container container = this.f_40218_;
            if (container instanceof IItemContainer) {
                IItemContainer itemCont = (IItemContainer)container;
                return itemCont.getMaxStackSize(this.getSlotIndex());
            }
            return super.m_6641_();
        }
    }
}

