/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials;

import com.Da_Technomancer.essentials.ESConfig;
import com.Da_Technomancer.essentials.api.ESProperties;
import com.Da_Technomancer.essentials.api.redstone.IRedstoneHandler;
import com.Da_Technomancer.essentials.blocks.BrazierTileEntity;
import com.Da_Technomancer.essentials.blocks.ESBlocks;
import com.Da_Technomancer.essentials.blocks.ESTileEntity;
import com.Da_Technomancer.essentials.blocks.WitherCannon;
import com.Da_Technomancer.essentials.items.ESItems;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.IContainerFactory;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;

public class ESEventHandlerCommon {
    @SubscribeEvent
    public static void blockWitchSpawns(MobSpawnEvent.FinalizeSpawn e) {
        ServerLevelAccessor serverLevelAccessor;
        if (e.getEntity() instanceof Witch && (serverLevelAccessor = e.getLevel()) instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)serverLevelAccessor;
            int RANGE = (Integer)ESConfig.brazierRange.get();
            int RANGE_SQUARED = (int)Math.pow(RANGE, 2.0);
            String dimKey = world.m_46472_().m_135782_().toString();
            HashSet<BlockPos> brazierPositions = BrazierTileEntity.BRAZIER_POSITIONS.get(dimKey);
            if (brazierPositions != null) {
                for (BlockPos otherPos : brazierPositions) {
                    BlockState state;
                    if (!(otherPos.m_203198_(e.getX(), e.getY(), e.getZ()) <= (double)RANGE_SQUARED) || (state = world.m_8055_(otherPos)).m_60734_() != ESBlocks.brazier || (Integer)state.m_61143_((Property)ESProperties.BRAZIER_CONTENTS) != 6) continue;
                    e.setSpawnCancelled(true);
                    return;
                }
            }
        }
    }

    @SubscribeEvent
    public static void preventTeleport(EntityTeleportEvent e) {
        EnderMan enderman;
        Entity entity = e.getEntity();
        if (entity instanceof EnderMan && (entity = (enderman = (EnderMan)entity).m_9236_()) instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)entity;
            int RANGE = (Integer)ESConfig.brazierRange.get();
            int RANGE_SQUARED = (int)Math.pow(RANGE, 2.0);
            String dimKey = world.m_46472_().m_135782_().toString();
            HashSet<BlockPos> brazierPositions = BrazierTileEntity.BRAZIER_POSITIONS.get(dimKey);
            if (brazierPositions != null) {
                for (BlockPos otherPos : brazierPositions) {
                    BlockState state;
                    if (!(otherPos.m_203198_(e.getPrevX(), e.getPrevY(), e.getPrevZ()) <= (double)RANGE_SQUARED) || (state = world.m_8055_(otherPos)).m_60734_() != ESBlocks.brazier || (Integer)state.m_61143_((Property)ESProperties.BRAZIER_CONTENTS) != 6) continue;
                    e.setResult(Event.Result.DENY);
                    return;
                }
            }
        }
    }

    @SubscribeEvent
    public static void feedAnimal(PlayerInteractEvent.EntityInteract e) {
        Entity entity = e.getTarget();
        if (entity instanceof Animal) {
            Animal an = (Animal)entity;
            if (e.getItemStack().m_41720_() == ESItems.animalFeed && (!(e.getTarget() instanceof TamableAnimal) || ((TamableAnimal)e.getTarget()).m_21824_())) {
                e.setResult(Event.Result.DENY);
                e.setCanceled(true);
                if (!e.getLevel().f_46443_ && an.m_146764_() == 0) {
                    an.m_27595_(e.getEntity());
                    if (!e.getEntity().m_7500_()) {
                        e.getItemStack().m_41774_(1);
                    }
                }
            }
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, modid="essentials")
    public static class ESModEventsCommon {
        @SubscribeEvent
        public static void registerCapabilities(RegisterCapabilitiesEvent e) {
            e.register(IRedstoneHandler.class);
        }

        @SubscribeEvent
        public static void register(RegisterEvent e) {
            e.register(ForgeRegistries.Keys.BLOCKS, ESBlocks::init);
            e.register(ForgeRegistries.Keys.ITEMS, ESItems::init);
            e.register(ForgeRegistries.Keys.ENTITY_TYPES, helper -> helper.register("cannon_skull", WitherCannon.CannonSkull.ENT_TYPE));
            e.register(ForgeRegistries.Keys.BLOCK_ENTITY_TYPES, helper -> {
                ESTileEntity.init();
                for (Map.Entry<String, BlockEntityType<?>> entry : ESTileEntity.toRegister.entrySet()) {
                    helper.register(entry.getKey(), entry.getValue());
                }
                ESTileEntity.toRegister.clear();
            });
            e.register(Registries.f_279569_, helper -> {
                ESItems.ESSENTIALS_TAB = CreativeModeTab.builder().m_257941_((Component)Component.m_237115_((String)"item_group.essentials")).m_257737_(() -> new ItemStack((ItemLike)ESItems.itemCandleLilypad)).m_257501_((params, output) -> {
                    for (Supplier<ItemStack[]> itemsToAdd : ESItems.creativeTabItems) {
                        for (ItemStack itemToAdd : itemsToAdd.get()) {
                            output.m_246342_(itemToAdd);
                        }
                    }
                }).m_257652_();
                helper.register("core", (Object)ESItems.ESSENTIALS_TAB);
            });
        }

        protected static <T extends AbstractContainerMenu> MenuType<T> registerConType(IContainerFactory<T> cons, String id, RegisterEvent.RegisterHelper<MenuType<?>> helper) {
            MenuType contType = new MenuType(cons, FeatureFlags.f_244377_);
            helper.register(id, (Object)contType);
            return contType;
        }
    }
}

