/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials;

import com.Da_Technomancer.essentials.api.ConfigUtil;
import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.nio.file.Path;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;

public class ESConfig {
    public static ForgeConfigSpec.BooleanValue addWrench;
    public static ForgeConfigSpec.IntValue brazierRange;
    public static ForgeConfigSpec.IntValue itemChuteRange;
    public static ForgeConfigSpec.DoubleValue fertileSoilRate;
    public static ForgeConfigSpec.IntValue maxRedstoneRange;
    public static ForgeConfigSpec.EnumValue<ConfigUtil.NumberTypes> numberDisplay;
    public static ForgeConfigSpec.IntValue wirelessRange;
    private static ForgeConfigSpec clientSpec;
    private static ForgeConfigSpec serverSpec;

    protected static void init() {
        ForgeConfigSpec.Builder clientBuilder = new ForgeConfigSpec.Builder();
        addWrench = clientBuilder.worldRestart().comment("Should the Wrench show up in the creative menu?").define("creative_wrench", true);
        numberDisplay = clientBuilder.comment(new String[]{"How should very large and small numbers be displayed?", "Options are: NORMAL, SCIENTIFIC, ENGINEERING, and HEX"}).defineEnum("num_display", (Enum)ConfigUtil.NumberTypes.SCIENTIFIC);
        clientSpec = clientBuilder.build();
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)clientSpec);
        ForgeConfigSpec.Builder serverBuilder = new ForgeConfigSpec.Builder();
        brazierRange = serverBuilder.comment(new String[]{"Range of the Brazier anti-witch effect", "Set to 0 to disable"}).defineInRange("brazier_range", 64, 0, 512);
        itemChuteRange = serverBuilder.comment("Maximum Transport Chutes in a line").defineInRange("chute_limit", 16, 0, 128);
        fertileSoilRate = serverBuilder.comment(new String[]{"Percent of normal speed Fertile Soil should work at", "Set to 0 to disable"}).defineInRange("fertile_rate", 100.0, 0.0, 100.0);
        maxRedstoneRange = serverBuilder.comment("Range of signals through Circuit Wire").defineInRange("redstone_range", 16, 1, 128);
        wirelessRange = serverBuilder.comment("Range of signals through Redstone Receivers/Transmitters").defineInRange("wireless_range", 32, 0, 128);
        serverSpec = serverBuilder.build();
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)serverSpec);
    }

    protected static void load() {
        CommentedFileConfig clientConfig = (CommentedFileConfig)CommentedFileConfig.builder((Path)FMLPaths.CONFIGDIR.get().resolve("essentials-client.toml")).sync().autosave().writingMode(WritingMode.REPLACE).build();
        clientConfig.load();
        clientSpec.setConfig((CommentedConfig)clientConfig);
        CommentedFileConfig serverConfig = (CommentedFileConfig)CommentedFileConfig.builder((Path)FMLPaths.CONFIGDIR.get().resolve("essentials-server.toml")).sync().autosave().writingMode(WritingMode.REPLACE).build();
        serverConfig.load();
        serverSpec.setConfig((CommentedConfig)serverConfig);
    }
}

