/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.util;

import com.cstav.genshinstrument.capability.instrumentOpen.InstrumentOpenProvider;
import com.cstav.genshinstrument.event.InstrumentPlayedEvent;
import com.cstav.genshinstrument.networking.IModPacket;
import com.cstav.genshinstrument.networking.ModPacketHandler;
import com.cstav.genshinstrument.networking.OpenInstrumentPacketSender;
import com.cstav.genshinstrument.networking.buttonidentifier.NoteButtonIdentifier;
import com.cstav.genshinstrument.networking.packet.instrument.NotifyInstrumentOpenPacket;
import com.cstav.genshinstrument.networking.packet.instrument.OpenInstrumentPacket;
import com.cstav.genshinstrument.networking.packet.instrument.PlayNotePacket;
import com.cstav.genshinstrument.sound.NoteSound;
import com.cstav.genshinstrument.util.CommonUtil;
import com.cstav.genshinstrument.util.PlayNotePacketDelegate;
import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.simple.SimpleChannel;
import org.slf4j.Logger;

public class ServerUtil {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final int PLAY_DISTANCE = 16;

    public static void sendPlayNotePackets(ServerPlayer player, NoteSound sound, ResourceLocation instrumentId, int pitch, int volume) {
        ServerUtil.sendPlayNotePackets(player, Optional.empty(), sound, instrumentId, null, pitch, volume, PlayNotePacket::new);
    }

    public static void sendPlayNotePackets(ServerPlayer player, Optional<BlockPos> pos, NoteSound sound, ResourceLocation instrumentId, NoteButtonIdentifier noteIdentifier, int pitch, int volume, PlayNotePacketDelegate notePacketDelegate) {
        PlayNotePacket packet = notePacketDelegate.create(pos, sound, pitch, volume, instrumentId, Optional.ofNullable(noteIdentifier), Optional.of(player.m_20148_()));
        BlockPos playeredPos = CommonUtil.getPlayeredPosition((Player)player, pos);
        for (Player listener : ServerUtil.noteListeners(player.m_9236_(), playeredPos)) {
            ModPacketHandler.sendToClient(packet, (ServerPlayer)listener);
        }
        player.m_9236_().m_220407_(GameEvent.f_223696_, playeredPos, GameEvent.Context.m_223717_((Entity)player));
        MinecraftForge.EVENT_BUS.post((Event)new InstrumentPlayedEvent.ByPlayer(sound, pitch, volume, (Player)player, playeredPos, instrumentId, noteIdentifier, false));
    }

    public static void sendPlayNotePackets(Level level, BlockPos pos, NoteSound sound, ResourceLocation instrumentId, int pitch, int volume) {
        ServerUtil.sendPlayNotePackets(level, pos, sound, instrumentId, null, pitch, volume, PlayNotePacket::new);
    }

    public static void sendPlayNotePackets(Level level, BlockPos pos, NoteSound sound, ResourceLocation instrumentId, NoteButtonIdentifier noteIdentifier, int pitch, int volume, PlayNotePacketDelegate notePacketDelegate) {
        PlayNotePacket packet = notePacketDelegate.create(Optional.of(pos), sound, pitch, volume, instrumentId, Optional.ofNullable(noteIdentifier), Optional.empty());
        for (Player listener : ServerUtil.noteListeners(level, pos)) {
            ModPacketHandler.sendToClient(packet, (ServerPlayer)listener);
        }
        BlockState bs = level.m_8055_(pos);
        if (bs != Blocks.f_50016_.m_49966_()) {
            level.m_220407_(GameEvent.f_223696_, pos, GameEvent.Context.m_223722_((BlockState)bs));
        } else {
            level.m_142346_(null, GameEvent.f_223696_, pos);
        }
        MinecraftForge.EVENT_BUS.post((Event)new InstrumentPlayedEvent(sound, pitch, volume, level, pos, instrumentId, noteIdentifier, false));
    }

    private static List<Player> noteListeners(Level level, BlockPos pos) {
        return CommonUtil.getPlayersInArea(level, new AABB(pos).m_82400_(16.0));
    }

    public static void setInstrumentClosed(Player player) {
        InstrumentOpenProvider.setClosed(player);
        player.m_9236_().m_6907_().forEach(nearbyPlayer -> ModPacketHandler.sendToClient(new NotifyInstrumentOpenPacket(player.m_20148_()), (ServerPlayer)nearbyPlayer));
    }

    public static Class<? extends NoteButtonIdentifier> getValidNoteIdentifier(String classType, List<Class<? extends NoteButtonIdentifier>> acceptableIdentifiers) throws ClassNotFoundException {
        for (Class<? extends NoteButtonIdentifier> identifier : acceptableIdentifiers) {
            if (!identifier.getName().equals(classType)) continue;
            return identifier;
        }
        throw new ClassNotFoundException("Class type " + classType + " could not be evaluated as part of the acceptable identifiers");
    }

    public static boolean sendOpenPacket(ServerPlayer player, InteractionHand usedHand, OpenInstrumentPacketSender onOpenRequest) {
        return ServerUtil.sendOpenPacket(player, usedHand, onOpenRequest, null);
    }

    public static boolean sendOpenPacket(ServerPlayer player, OpenInstrumentPacketSender onOpenRequest, BlockPos pos) {
        return ServerUtil.sendOpenPacket(player, null, onOpenRequest, pos);
    }

    private static boolean sendOpenPacket(ServerPlayer player, InteractionHand usedHand, OpenInstrumentPacketSender onOpenRequest, BlockPos pos) {
        NotifyInstrumentOpenPacket instrumentOpenPacket;
        if (pos == null) {
            InstrumentOpenProvider.setOpen((Player)player, usedHand);
            instrumentOpenPacket = new NotifyInstrumentOpenPacket(player.m_20148_(), usedHand);
        } else {
            InstrumentOpenProvider.setOpen((Player)player, pos);
            instrumentOpenPacket = new NotifyInstrumentOpenPacket(player.m_20148_(), pos);
        }
        player.m_9236_().m_6907_().forEach(otherPlayer -> ModPacketHandler.sendToClient(instrumentOpenPacket, (ServerPlayer)otherPlayer));
        onOpenRequest.send(player);
        return true;
    }

    public static void sendInternalOpenPacket(ServerPlayer player, String instrumentType) {
        ModPacketHandler.sendToClient(new OpenInstrumentPacket(instrumentType), player);
    }

    public static void registerModPackets(SimpleChannel sc, List<Class<IModPacket>> acceptablePackets, Supplier<Integer> id) {
        for (Class<IModPacket> packetType : acceptablePackets) {
            try {
                sc.registerMessage(id.get().intValue(), packetType, IModPacket::write, buf -> {
                    try {
                        return (IModPacket)packetType.getDeclaredConstructor(FriendlyByteBuf.class).newInstance(buf);
                    }
                    catch (Exception e) {
                        LOGGER.error("Error constructing packet of type " + packetType.getName(), (Throwable)e);
                        return null;
                    }
                }, (msg, supplier) -> {
                    NetworkEvent.Context context = (NetworkEvent.Context)supplier.get();
                    context.enqueueWork(() -> msg.handle(context));
                    context.setPacketHandled(true);
                }, ServerUtil.getDirection(packetType));
            }
            catch (Exception e) {
                LOGGER.error("Error registering packet of type " + packetType.getName() + ". Make sure to have a NETWORK_DIRECTION static field of type NetworkDirection.", (Throwable)e);
            }
        }
    }

    private static Optional<NetworkDirection> getDirection(Class<IModPacket> packetType) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, SecurityException {
        return Optional.of((NetworkDirection)packetType.getField("NETWORK_DIRECTION").get(null));
    }
}

