/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.sound;

import com.cstav.genshinstrument.sound.NoteSound;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import org.slf4j.Logger;

public class NoteSoundRegistrar {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final HashMap<ResourceLocation, NoteSound[]> SOUNDS_REGISTRY = new HashMap();
    public static final String STEREO_SUFFIX = "_stereo";
    private final DeferredRegister<SoundEvent> soundRegistrar;
    private final ResourceLocation baseSoundLocation;
    private boolean hasStereo = false;
    private boolean alreadyRegistered = false;
    private final ArrayList<NoteSound> stackedSounds = new ArrayList();

    public static NoteSound[] getSounds(ResourceLocation baseSoundName) {
        return SOUNDS_REGISTRY.get(baseSoundName);
    }

    public NoteSoundRegistrar(DeferredRegister<SoundEvent> soundRegistrar, ResourceLocation baseSoundLocation) {
        this.soundRegistrar = soundRegistrar;
        this.baseSoundLocation = baseSoundLocation;
    }

    public NoteSoundRegistrar stereo() {
        this.hasStereo = true;
        return this;
    }

    public NoteSoundRegistrar alreadyRegistered() {
        this.alreadyRegistered = true;
        return this;
    }

    public NoteSound[] register(NoteSound[] noteSounds) {
        SOUNDS_REGISTRY.put(this.baseSoundLocation, noteSounds);
        LOGGER.info("Successfully registered " + noteSounds.length + " note sounds of " + this.baseSoundLocation);
        return noteSounds;
    }

    public NoteSound[] registerGrid(int rows, int columns) {
        NoteSound[] sounds = new NoteSound[rows * columns];
        for (int i = 0; i < sounds.length; ++i) {
            sounds[i] = this.createNote(i);
        }
        return this.register(sounds);
    }

    public NoteSound[] registerGrid() {
        return this.registerGrid(7, 3);
    }

    public ChainedNoteSoundRegistrar chain(ResourceLocation soundLocation) {
        this.validateNotChained();
        return new ChainedNoteSoundRegistrar(soundLocation);
    }

    public NoteSound peek() {
        this.validateNotChained();
        return this.stackedSounds.get(this.stackedSounds.size() - 1);
    }

    public NoteSound[] registerAll() {
        this.validateNotChained();
        return this.register((NoteSound[])this.stackedSounds.toArray(NoteSound[]::new));
    }

    public NoteSoundRegistrar add() {
        throw new IllegalStateException("Called add() on a non-chained registrar!");
    }

    private void validateNotChained() {
        if (this instanceof ChainedNoteSoundRegistrar) {
            throw new IllegalStateException("Called non-chainable method on a chained registrar!");
        }
    }

    public NoteSound registerNote() {
        return this.createNote(this.baseSoundLocation, 0);
    }

    protected NoteSound createNote(ResourceLocation soundLocation, int index) {
        NoteSound sound = new NoteSound(index, this.baseSoundLocation);
        this.setSoundField(soundEvent -> {
            sound.mono = soundEvent;
            return sound.mono;
        }, soundLocation);
        if (this.hasStereo) {
            this.setSoundField(soundEvent -> {
                sound.stereo = soundEvent;
                return sound.stereo;
            }, soundLocation.m_266382_(STEREO_SUFFIX));
        }
        return sound;
    }

    private void setSoundField(Function<SoundEvent, SoundEvent> fieldConsumer, ResourceLocation soundLocation) {
        if (this.alreadyRegistered) {
            fieldConsumer.apply((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(soundLocation));
        } else {
            this.soundRegistrar.register(soundLocation.m_135815_(), () -> (SoundEvent)fieldConsumer.apply(SoundEvent.m_262824_((ResourceLocation)soundLocation)));
        }
    }

    public NoteSound createNote(int noteIndex) {
        return this.createNote(this.baseSoundLocation.m_266382_("_note_" + noteIndex), noteIndex);
    }

    public class ChainedNoteSoundRegistrar
    extends NoteSoundRegistrar {
        private final ResourceLocation soundLocation;

        private ChainedNoteSoundRegistrar(ResourceLocation soundLocation) {
            super(NoteSoundRegistrar.this.soundRegistrar, NoteSoundRegistrar.this.baseSoundLocation);
            this.soundLocation = soundLocation;
        }

        @Override
        public NoteSoundRegistrar add() {
            NoteSoundRegistrar original = NoteSoundRegistrar.this;
            ArrayList<NoteSound> stackedSounds = original.stackedSounds;
            stackedSounds.add(this.createNote(this.soundLocation, stackedSounds.size()));
            return original;
        }
    }
}

