/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.sound;

import com.cstav.genshinstrument.client.config.ModClientConfigs;
import com.cstav.genshinstrument.client.config.enumType.InstrumentChannelType;
import com.cstav.genshinstrument.event.InstrumentPlayedEvent;
import com.cstav.genshinstrument.networking.buttonidentifier.NoteButtonIdentifier;
import com.cstav.genshinstrument.sound.NoteSoundRegistrar;
import com.cstav.genshinstrument.sound.NoteSoundReuslt;
import com.cstav.genshinstrument.util.CommonUtil;
import com.cstav.genshinstrument.util.LabelUtil;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class NoteSound {
    public static final double STEREO_RANGE = 5.5;
    public static final double STOP_SOUND_DISTANCE = 10.0;
    public static final double LOCAL_RANGE = 5.5;
    public static final int MIN_PITCH = -LabelUtil.NOTES_PER_SCALE;
    public static final int MAX_PITCH = LabelUtil.NOTES_PER_SCALE;
    public final int index;
    public final ResourceLocation baseSoundLocation;
    SoundEvent mono;
    SoundEvent stereo;

    NoteSound(int index, ResourceLocation baseSoundLocation) {
        this.index = index;
        this.baseSoundLocation = baseSoundLocation;
    }

    public SoundEvent getMono() {
        return this.mono;
    }

    public boolean hasStereo() {
        return this.stereo != null;
    }

    @Nullable
    public SoundEvent getStereo() {
        return this.stereo;
    }

    public NoteSound[] getSoundsArr() {
        return NoteSoundRegistrar.getSounds(this.baseSoundLocation);
    }

    public NoteSoundReuslt transpose(int amount) {
        int newIndex = amount + this.index;
        NoteSound[] sounds = this.getSoundsArr();
        int delta = newIndex / sounds.length;
        if (delta != 0) {
            if (delta < -1 || delta > 1) {
                return new NoteSoundReuslt(null, delta);
            }
            newIndex += sounds.length * delta;
        }
        return new NoteSoundReuslt(sounds[newIndex], delta);
    }

    @OnlyIn(value=Dist.CLIENT)
    public SoundEvent getByPreference(double distanceFromPlayer) {
        if (!this.hasStereo()) {
            return this.mono;
        }
        InstrumentChannelType preference = (InstrumentChannelType)((Object)ModClientConfigs.CHANNEL_TYPE.get());
        return switch (preference) {
            default -> throw new IncompatibleClassChangeError();
            case InstrumentChannelType.MIXED -> {
                if (NoteSound.metInstrumentVolume() && distanceFromPlayer <= 5.5) {
                    yield this.getStereo();
                }
                yield this.mono;
            }
            case InstrumentChannelType.STEREO -> this.getStereo();
            case InstrumentChannelType.MONO -> this.mono;
        };
    }

    @OnlyIn(value=Dist.CLIENT)
    public SoundEvent getByPreference() {
        if (!this.hasStereo()) {
            return this.mono;
        }
        InstrumentChannelType preference = (InstrumentChannelType)((Object)ModClientConfigs.CHANNEL_TYPE.get());
        return switch (preference) {
            default -> throw new IncompatibleClassChangeError();
            case InstrumentChannelType.MIXED -> {
                if (NoteSound.metInstrumentVolume()) {
                    yield this.getStereo();
                }
                yield this.mono;
            }
            case InstrumentChannelType.STEREO -> this.getStereo();
            case InstrumentChannelType.MONO -> this.mono;
        };
    }

    private static boolean metInstrumentVolume() {
        return Minecraft.m_91087_().f_91066_.m_92147_(SoundSource.RECORDS) == 1.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void play(int pitch, int volume, Optional<UUID> playerUUID, ResourceLocation instrumentId, Optional<NoteButtonIdentifier> buttonIdentifier, Optional<BlockPos> playPos) {
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        ClientLevel level = minecraft.f_91073_;
        Player initiator = playerUUID.map(arg_0 -> ((Level)level).m_46003_(arg_0)).orElse(null);
        BlockPos pos = CommonUtil.getPlayeredPosition(initiator, playPos);
        double distanceFromPlayer = Math.sqrt(pos.m_203193_((Position)player.m_20182_()));
        if (((Boolean)ModClientConfigs.STOP_MUSIC_ON_PLAY.get()).booleanValue() && distanceFromPlayer < 10.0) {
            minecraft.m_91397_().m_120186_();
        }
        MinecraftForge.EVENT_BUS.post((Event)(initiator == null ? new InstrumentPlayedEvent(this, pitch, volume, (Level)level, pos, instrumentId, buttonIdentifier.orElse(null), true) : new InstrumentPlayedEvent.ByPlayer(this, pitch, volume, initiator, pos, instrumentId, (NoteButtonIdentifier)buttonIdentifier.orElse(null), true)));
        if (player.equals((Object)initiator)) {
            return;
        }
        float mcPitch = NoteSound.getPitchByNoteOffset(NoteSound.clampPitch(pitch));
        if (distanceFromPlayer > 5.5) {
            level.m_245747_(pos, this.getByPreference(distanceFromPlayer), SoundSource.RECORDS, 1.0f, mcPitch, false);
        } else {
            this.playLocally(mcPitch, (float)volume / 100.0f);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void playLocally(float pitch, float volume) {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new SimpleSoundInstance(this.getByPreference().m_11660_(), SoundSource.RECORDS, volume, pitch, SoundInstance.m_235150_(), false, 0, SoundInstance.Attenuation.NONE, 0.0, 0.0, 0.0, true));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void playLocally(int pitch, float volume) {
        this.playLocally(NoteSound.getPitchByNoteOffset(NoteSound.clampPitch(pitch)), volume);
    }

    public static int clampPitch(int pitch) {
        return Mth.m_14045_((int)pitch, (int)MIN_PITCH, (int)MAX_PITCH);
    }

    public static float getPitchByNoteOffset(int pitch) {
        return (float)Math.pow(2.0, (double)pitch / (double)LabelUtil.NOTES_PER_SCALE);
    }

    public void writeToNetwork(FriendlyByteBuf buf) {
        buf.m_130085_(this.baseSoundLocation);
        buf.writeInt(this.index);
    }

    public static NoteSound readFromNetwork(FriendlyByteBuf buf) {
        return NoteSoundRegistrar.getSounds(buf.m_130281_())[buf.readInt()];
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof NoteSound)) {
            return false;
        }
        NoteSound other = (NoteSound)obj;
        return this.baseSoundLocation.equals((Object)other.baseSoundLocation) && this.index == other.index;
    }
}

