/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.networking.packet.instrument;

import com.cstav.genshinstrument.networking.buttonidentifier.NoteButtonIdentifier;
import com.cstav.genshinstrument.networking.packet.INoteIdentifierSender;
import com.cstav.genshinstrument.sound.NoteSound;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class PlayNotePacket
implements INoteIdentifierSender {
    public static final NetworkDirection NETWORK_DIRECTION = NetworkDirection.PLAY_TO_CLIENT;
    private final int pitch;
    private final int volume;
    private final Optional<BlockPos> position;
    private final NoteSound sound;
    private final ResourceLocation instrumentId;
    private final Optional<NoteButtonIdentifier> noteIdentifier;
    private final Optional<UUID> playerUUID;

    public PlayNotePacket(Optional<BlockPos> pos, NoteSound sound, int pitch, int volume, ResourceLocation instrumentId, Optional<NoteButtonIdentifier> noteIdentifier, Optional<UUID> playerUUID) {
        this.pitch = pitch;
        this.volume = volume;
        this.position = pos;
        this.sound = sound;
        this.instrumentId = instrumentId;
        this.noteIdentifier = noteIdentifier;
        this.playerUUID = playerUUID;
    }

    public PlayNotePacket(FriendlyByteBuf buf) {
        this.pitch = buf.readInt();
        this.volume = buf.readInt();
        this.position = buf.m_236860_(FriendlyByteBuf::m_130135_);
        this.sound = NoteSound.readFromNetwork(buf);
        this.instrumentId = buf.m_130281_();
        this.noteIdentifier = buf.m_236860_(this::readNoteIdentifierFromNetwork);
        this.playerUUID = buf.m_236860_(FriendlyByteBuf::m_130259_);
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.pitch);
        buf.writeInt(this.volume);
        buf.m_236835_(this.position, FriendlyByteBuf::m_130064_);
        this.sound.writeToNetwork(buf);
        buf.m_130085_(this.instrumentId);
        buf.m_236835_(this.noteIdentifier, (fbb, identifier) -> identifier.writeToNetwork((FriendlyByteBuf)fbb));
        buf.m_236835_(this.playerUUID, FriendlyByteBuf::m_130077_);
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        this.sound.play(this.pitch, this.volume, this.playerUUID, this.instrumentId, this.noteIdentifier, this.position);
    }
}

