/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.networking.packet.instrument;

import com.cstav.genshinstrument.client.gui.screen.instrument.drum.AratakisGreatAndGloriousDrumScreen;
import com.cstav.genshinstrument.client.gui.screen.instrument.floralzither.FloralZitherScreen;
import com.cstav.genshinstrument.client.gui.screen.instrument.vintagelyre.VintageLyreScreen;
import com.cstav.genshinstrument.client.gui.screen.instrument.windsonglyre.WindsongLyreScreen;
import com.cstav.genshinstrument.networking.IModPacket;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class OpenInstrumentPacket
implements IModPacket {
    public static final NetworkDirection NETWORK_DIRECTION = NetworkDirection.PLAY_TO_CLIENT;
    private static final Map<String, Supplier<Supplier<Screen>>> INSTRUMENT_MAP = Map.of("windsong_lyre", () -> WindsongLyreScreen::new, "vintage_lyre", () -> VintageLyreScreen::new, "floral_zither", () -> FloralZitherScreen::new, "glorious_drum", () -> AratakisGreatAndGloriousDrumScreen::new);
    private final String instrumentType;

    protected Map<String, Supplier<Supplier<Screen>>> getInstrumentMap() {
        return INSTRUMENT_MAP;
    }

    public OpenInstrumentPacket(String instrumentScreen) {
        this.instrumentType = instrumentScreen;
    }

    public OpenInstrumentPacket(FriendlyByteBuf buf) {
        this.instrumentType = buf.m_130277_();
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.m_130070_(this.instrumentType);
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> Minecraft.m_91087_().m_91152_(this.getInstrumentMap().get(this.instrumentType).get().get()));
    }
}

