/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.networking.packet.instrument;

import com.cstav.genshinstrument.capability.instrumentOpen.InstrumentOpen;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.NoteButton;
import com.cstav.genshinstrument.networking.buttonidentifier.NoteButtonIdentifier;
import com.cstav.genshinstrument.networking.packet.INoteIdentifierSender;
import com.cstav.genshinstrument.networking.packet.instrument.PlayNotePacket;
import com.cstav.genshinstrument.sound.NoteSound;
import com.cstav.genshinstrument.util.ServerUtil;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class InstrumentPacket
implements INoteIdentifierSender {
    public static final NetworkDirection NETWORK_DIRECTION = NetworkDirection.PLAY_TO_SERVER;
    private final Optional<BlockPos> pos;
    private final NoteSound sound;
    private final int pitch;
    private final int volume;
    private final ResourceLocation instrumentId;
    private final Optional<NoteButtonIdentifier> noteIdentifier;

    public InstrumentPacket(Optional<BlockPos> pos, NoteSound sound, int pitch, int volume, ResourceLocation instrumentId, Optional<NoteButtonIdentifier> noteIdentifier) {
        this.pos = pos;
        this.sound = sound;
        this.pitch = pitch;
        this.volume = volume;
        this.instrumentId = instrumentId;
        this.noteIdentifier = noteIdentifier;
    }

    @OnlyIn(value=Dist.CLIENT)
    public InstrumentPacket(NoteButton noteButton) {
        this(Optional.empty(), noteButton.getSound(), noteButton.getPitch(), noteButton.instrumentScreen.volume, noteButton.instrumentScreen.getInstrumentId(), Optional.ofNullable(noteButton.getIdentifier()));
    }

    public InstrumentPacket(FriendlyByteBuf buf) {
        this.pos = buf.m_236860_(FriendlyByteBuf::m_130135_);
        this.sound = NoteSound.readFromNetwork(buf);
        this.pitch = buf.readInt();
        this.volume = buf.readInt();
        this.instrumentId = buf.m_130281_();
        this.noteIdentifier = buf.m_236860_(this::readNoteIdentifierFromNetwork);
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.m_236835_(this.pos, FriendlyByteBuf::m_130064_);
        this.sound.writeToNetwork(buf);
        buf.writeInt(this.pitch);
        buf.writeInt(this.volume);
        buf.m_130085_(this.instrumentId);
        buf.m_236835_(this.noteIdentifier, (fbb, identifier) -> identifier.writeToNetwork((FriendlyByteBuf)fbb));
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        ServerPlayer player = context.getSender();
        if (!InstrumentOpen.isOpen((Player)player)) {
            return;
        }
        this.sendPlayNotePackets(player);
    }

    protected void sendPlayNotePackets(ServerPlayer player) {
        ServerUtil.sendPlayNotePackets(player, this.pos, this.sound, this.instrumentId, (NoteButtonIdentifier)this.noteIdentifier.orElse(null), this.pitch, this.volume, PlayNotePacket::new);
    }
}

