/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.networking.buttonidentifier;

import com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.NoteButton;
import com.cstav.genshinstrument.util.ServerUtil;
import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class NoteButtonIdentifier {
    public void writeToNetwork(FriendlyByteBuf buf) {
        buf.m_130070_(this.getClass().getName());
    }

    public abstract boolean matches(NoteButtonIdentifier var1);

    @OnlyIn(value=Dist.CLIENT)
    public boolean matches(NoteButton note) {
        return this.matches(note.getIdentifier());
    }

    public boolean equals(Object other) {
        NoteButtonIdentifier _other;
        return other instanceof NoteButtonIdentifier && this.matches(_other = (NoteButtonIdentifier)other);
    }

    public static NoteButtonIdentifier readFromNetwork(FriendlyByteBuf buf, List<Class<? extends NoteButtonIdentifier>> acceptableIdentifiers) {
        try {
            return ServerUtil.getValidNoteIdentifier(buf.m_130277_(), acceptableIdentifiers).getDeclaredConstructor(FriendlyByteBuf.class).newInstance(buf);
        }
        catch (Exception e) {
            LogUtils.getLogger().error("Error initializing button identifier", (Throwable)e);
            return null;
        }
    }

    public static abstract class MatchType {
        public static <T extends NoteButtonIdentifier> boolean hierarchyMatch(NoteButtonIdentifier other, Function<T, Boolean> matchFunction, Function<NoteButtonIdentifier, Boolean> unmatchFunction) {
            try {
                return matchFunction.apply(other) != false || unmatchFunction.apply(other) != false;
            }
            catch (ClassCastException e) {
                return unmatchFunction.apply(other);
            }
        }

        public static <T extends NoteButtonIdentifier> boolean preferMatch(NoteButtonIdentifier other, Function<T, Boolean> preferredFunction, Function<NoteButtonIdentifier, Boolean> secondaryFunction) {
            try {
                return preferredFunction.apply(other);
            }
            catch (ClassCastException e) {
                return secondaryFunction.apply(other);
            }
        }

        public static <T extends NoteButtonIdentifier> boolean forceMatch(NoteButtonIdentifier other, Function<T, Boolean> matchFunction) {
            try {
                return matchFunction.apply(other);
            }
            catch (ClassCastException e) {
                return false;
            }
        }
    }
}

