/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.event;

import com.cstav.genshinstrument.block.partial.InstrumentBlockEntity;
import com.cstav.genshinstrument.capability.instrumentOpen.InstrumentOpenProvider;
import com.cstav.genshinstrument.networking.buttonidentifier.NoteButtonIdentifier;
import com.cstav.genshinstrument.sound.NoteSound;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;

@Cancelable
public class InstrumentPlayedEvent
extends Event {
    public final NoteSound sound;
    public final int pitch;
    public final int volume;
    public final Level level;
    public final boolean isClientSide;
    public final ResourceLocation instrumentId;
    public final Optional<NoteButtonIdentifier> noteIdentifier;
    public final BlockPos playPos;

    public float volume() {
        return (float)this.volume / 100.0f;
    }

    public InstrumentPlayedEvent(NoteSound sound, int pitch, int volume, Level level, BlockPos pos, ResourceLocation instrumentId, NoteButtonIdentifier noteIdentifier, boolean isClientSide) {
        this.sound = sound;
        this.pitch = pitch;
        this.volume = volume;
        this.level = level;
        this.playPos = pos;
        this.isClientSide = isClientSide;
        this.instrumentId = instrumentId;
        this.noteIdentifier = Optional.ofNullable(noteIdentifier);
    }

    @Cancelable
    public static class ByPlayer
    extends InstrumentPlayedEvent {
        public final Player player;
        public final Optional<ItemStack> itemInstrument;
        public final Optional<InteractionHand> hand;

        public boolean isItemInstrument() {
            return this.itemInstrument.isPresent();
        }

        public boolean isBlockInstrument() {
            return !this.isItemInstrument() && this.player.m_9236_().m_7702_(this.playPos) instanceof InstrumentBlockEntity;
        }

        public boolean isNotInstrument() {
            return !this.isBlockInstrument() && !this.isItemInstrument();
        }

        public ByPlayer(NoteSound sound, int pitch, int volume, Player player, BlockPos pos, ResourceLocation instrumentId, NoteButtonIdentifier noteIdentifier, boolean isClientSide) {
            super(sound, pitch, volume, player.m_9236_(), pos, instrumentId, noteIdentifier, isClientSide);
            this.player = player;
            if (InstrumentOpenProvider.isItem(player)) {
                this.hand = Optional.of(InstrumentOpenProvider.getHand(player));
                this.itemInstrument = Optional.of(player.m_21120_(this.hand.get()));
            } else {
                this.hand = Optional.empty();
                this.itemInstrument = Optional.empty();
            }
        }
    }
}

