/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.event;

import com.cstav.genshinstrument.block.partial.AbstractInstrumentBlock;
import com.cstav.genshinstrument.capability.instrumentOpen.InstrumentOpenProvider;
import com.cstav.genshinstrument.client.config.ModClientConfigs;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.InstrumentScreen;
import com.cstav.genshinstrument.client.midi.MidiController;
import com.cstav.genshinstrument.event.InstrumentPlayedEvent;
import com.cstav.genshinstrument.event.MidiEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.event.GameShuttingDownEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, modid="genshinstrument", value={Dist.CLIENT})
public class ClientEvents {
    private static final Minecraft MINECRAFT = Minecraft.m_91087_();

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        InstrumentScreen.getCurrentScreen(MINECRAFT).ifPresent(InstrumentScreen::handleAbruptClosing);
    }

    @SubscribeEvent
    public static void prePlayerRenderEvent(RenderPlayerEvent.Pre event) {
        Player player = event.getEntity();
        if (!InstrumentOpenProvider.isOpen(player) || InstrumentOpenProvider.isItem(player)) {
            return;
        }
        Block block = player.m_9236_().m_8055_(InstrumentOpenProvider.getBlockPos(player)).m_60734_();
        if (!(block instanceof AbstractInstrumentBlock)) {
            return;
        }
        AbstractInstrumentBlock instrumentBlock = (AbstractInstrumentBlock)block;
        PlayerModel model = (PlayerModel)event.getRenderer().m_7200_();
        model.f_102815_ = model.f_102816_ = instrumentBlock.getClientBlockArmPose();
    }

    @SubscribeEvent
    public static void onInstrumentPlayed(InstrumentPlayedEvent event) {
        if (!event.isClientSide) {
            return;
        }
        if (!((Boolean)ModClientConfigs.SHARED_INSTRUMENT.get()).booleanValue()) {
            return;
        }
        if (event instanceof InstrumentPlayedEvent.ByPlayer && ((InstrumentPlayedEvent.ByPlayer)event).player.equals((Object)ClientEvents.MINECRAFT.f_91074_)) {
            return;
        }
        if (!event.playPos.m_123314_((Vec3i)ClientEvents.MINECRAFT.f_91074_.m_20183_(), 5.5)) {
            return;
        }
        InstrumentScreen.getCurrentScreen(MINECRAFT).filter(screen -> screen.getInstrumentId().equals((Object)event.instrumentId)).ifPresent(screen -> {
            try {
                screen.getNoteButton(event.noteIdentifier, event.sound, event.pitch).playNoteAnimation(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    @SubscribeEvent
    public static void onMidiEvent(MidiEvent event) {
        InstrumentScreen.getCurrentScreen(Minecraft.m_91087_()).filter(InstrumentScreen::isMidiInstrument).ifPresent(instrument -> instrument.midiReceiver.onMidi(event));
    }

    @SubscribeEvent
    public static void onGameShutdown(GameShuttingDownEvent event) {
        MidiController.unloadDevice();
    }
}

