/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.client.midi;

import com.cstav.genshinstrument.event.MidiEvent;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Transmitter;
import net.minecraft.util.thread.BlockableEventLoop;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.LogicalSide;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public abstract class MidiController {
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final LinkedHashMap<MidiDevice.Info, MidiDevice> DEVICES = new LinkedHashMap();
    private static MidiDevice currDevice;
    private static Transmitter deviceTransmitter;
    private static MidiDevice.Info info;
    private static boolean isTransmitting;

    public static void reloadDevices() {
        LOGGER.info("Reloading MIDI devices...");
        DEVICES.clear();
        MidiDevice.Info[] infos = MidiSystem.getMidiDeviceInfo();
        for (int i = 0; i < infos.length; ++i) {
            try {
                MidiDevice device = MidiSystem.getMidiDevice(infos[i]);
                device.getTransmitter();
                DEVICES.put(infos[i], device);
                continue;
            }
            catch (MidiUnavailableException e) {
                LOGGER.warn("MIDI device " + infos[i] + " cannot transmit any MIDI; ommitting!");
                continue;
            }
            catch (Exception e) {
                LOGGER.error("Unexpected error occured while trying to obtain MIDI device!", (Throwable)e);
            }
        }
    }

    public static boolean reloadIfEmpty() {
        if (DEVICES.isEmpty()) {
            MidiController.reloadDevices();
        }
        return DEVICES.isEmpty();
    }

    public static List<Integer> getValuesForOption() {
        ArrayList<Integer> result = new ArrayList<Integer>(DEVICES.size() + 1);
        result.add(-1);
        for (int i = 0; i < DEVICES.size(); ++i) {
            result.add(i);
        }
        return result;
    }

    public static void loadDevice(int infoIndex) {
        if (MidiController.reloadIfEmpty()) {
            LOGGER.warn("Attempted to load MIDI device #" + infoIndex + ", but there are no devices available!");
            return;
        }
        MidiController.unloadDevice();
        info = MidiController.getInfoFromIndex(infoIndex);
        currDevice = DEVICES.get(info);
    }

    public static void unloadDevice() {
        if (deviceTransmitter != null) {
            deviceTransmitter.close();
        }
        if (currDevice != null) {
            currDevice.close();
        }
        isTransmitting = false;
    }

    public static MidiDevice getCurrDevice() {
        return currDevice;
    }

    public static Transmitter getDeviceTransmitter() {
        return deviceTransmitter;
    }

    public static boolean isLoaded(int infoIndex) {
        return info != null && info.equals(MidiController.getInfoFromIndex(infoIndex));
    }

    public static void openForListen() {
        if (isTransmitting || currDevice == null) {
            return;
        }
        try {
            currDevice.open();
            deviceTransmitter = currDevice.getTransmitter();
            deviceTransmitter.setReceiver(new Receiver(){

                @Override
                public void send(MidiMessage message, long timeStamp) {
                    ((BlockableEventLoop)LogicalSidedProvider.WORKQUEUE.get(LogicalSide.CLIENT)).m_18709_(() -> MinecraftForge.EVENT_BUS.post((Event)new MidiEvent(message, timeStamp)));
                }

                @Override
                public void close() {
                }
            });
            isTransmitting = true;
        }
        catch (Exception e) {
            LOGGER.error("Error occured while opening MIDI device for listen!\nDevice: " + MidiController.infoAsString(info), (Throwable)e);
        }
    }

    public static boolean isTransmitting() {
        return isTransmitting;
    }

    public static int getInfoSerial(MidiDevice.Info info) {
        int i = 0;
        for (MidiDevice.Info _info : DEVICES.keySet()) {
            if (info.equals(_info)) {
                return i;
            }
            ++i;
        }
        LOGGER.error("Failed to retrieve info from devices map!: " + MidiController.infoAsString(info), (Throwable)new RuntimeException());
        return -1;
    }

    public static MidiDevice.Info getInfoFromIndex(int index) {
        Iterator<MidiDevice.Info> infoIterator = DEVICES.keySet().iterator();
        for (int i = 0; i < index; ++i) {
            infoIterator.next();
        }
        return infoIterator.next();
    }

    public static String infoAsString(MidiDevice.Info info) {
        return info.getName() + " - " + info.getDescription() + " (" + info.getVendor() + ")";
    }

    static {
        isTransmitting = false;
    }
}

