/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.client.midi;

import com.cstav.genshinstrument.client.config.ModClientConfigs;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.InstrumentScreen;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.NoteButton;
import com.cstav.genshinstrument.client.midi.MidiController;
import com.cstav.genshinstrument.client.midi.MidiOutOfRangeException;
import com.cstav.genshinstrument.event.MidiEvent;
import com.cstav.genshinstrument.sound.NoteSound;
import com.mojang.logging.LogUtils;

public abstract class InstrumentMidiReceiver {
    public static final int MIN_MIDI_VELOCITY = 6;
    public final InstrumentScreen instrument;
    private NoteButton pressedMidiNote = null;

    public InstrumentMidiReceiver(InstrumentScreen instrument) {
        this.instrument = instrument;
        this.loadMidiDevices();
    }

    protected void loadMidiDevices() {
        int infoIndex = (Integer)ModClientConfigs.MIDI_DEVICE_INDEX.get();
        if (infoIndex == -1) {
            return;
        }
        MidiController.reloadIfEmpty();
        if (infoIndex > MidiController.DEVICES.size() - 1) {
            LogUtils.getLogger().warn("MIDI device out of range; setting device to none");
            ModClientConfigs.MIDI_DEVICE_INDEX.set((Object)-1);
            return;
        }
        if (!MidiController.isLoaded(infoIndex)) {
            MidiController.loadDevice(infoIndex);
            MidiController.openForListen();
        }
    }

    protected abstract NoteButton handleMidiPress(int var1, int var2);

    public void onMidi(MidiEvent event) {
        int note;
        if (!this.canPerformMidi(event)) {
            return;
        }
        byte[] message = event.message.getMessage();
        this.instrument.resetTransposition();
        try {
            note = this.handleMidiOverflow(this.getLowC(message[1]));
        }
        catch (MidiOutOfRangeException e) {
            return;
        }
        boolean pitch = false;
        float prevVolume = this.instrument.volume();
        if (!((Boolean)ModClientConfigs.FIXED_TOUCH.get()).booleanValue()) {
            this.instrument.volume = (int)((double)this.instrument.volume * ((double)Math.max(6, message[2]) / 127.0));
        }
        this.pressedMidiNote = this.handleMidiPress(note, 0);
        if (this.pressedMidiNote != null) {
            this.pressedMidiNote.play();
        }
        this.instrument.setVolume(prevVolume);
    }

    protected boolean canPerformMidi(MidiEvent event) {
        int eventType;
        byte[] message = event.message.getMessage();
        if (this.pressedMidiNote != null) {
            this.pressedMidiNote.locked = false;
        }
        if ((eventType = message[0] >> 4 << 4) != -112) {
            return false;
        }
        if (!((Boolean)ModClientConfigs.ACCEPT_ALL_CHANNELS.get()).booleanValue()) {
            return message[0] - eventType == (Integer)ModClientConfigs.MIDI_CHANNEL.get();
        }
        return true;
    }

    protected boolean shouldSharpen(int layoutNote, int key) {
        boolean shouldSharpen;
        boolean higherThan3 = layoutNote > key + 4;
        boolean bl = shouldSharpen = layoutNote % 2 != key % 2;
        if (higherThan3) {
            boolean bl2 = shouldSharpen = !shouldSharpen;
        }
        if (layoutNote < key) {
            shouldSharpen = !shouldSharpen;
        }
        return shouldSharpen;
    }

    protected boolean shouldFlatten(boolean shouldSharpen) {
        return shouldSharpen && this.instrument.getPitch() == NoteSound.MAX_PITCH;
    }

    protected void transposeMidi(boolean shouldSharpen, boolean shouldFlatten) {
        if (shouldFlatten) {
            this.instrument.transposeDown();
        } else if (shouldSharpen) {
            this.instrument.transposeUp();
        }
    }

    protected int handleMidiOverflow(int note) throws MidiOutOfRangeException {
        if (!this.allowMidiOverflow() || !((Boolean)ModClientConfigs.EXTEND_OCTAVES.get()).booleanValue()) {
            if (note < this.minMidiNote() || note >= this.maxMidiNote()) {
                throw new MidiOutOfRangeException();
            }
            return note;
        }
        int minPitch = NoteSound.MIN_PITCH;
        int maxPitch = NoteSound.MAX_PITCH;
        if (note < this.minMidiNote()) {
            if (note < this.minMidiOverflow()) {
                throw new MidiOutOfRangeException();
            }
            if (this.instrument.getPitch() != minPitch) {
                this.overflowMidi(minPitch);
            }
        } else if (note >= this.maxMidiNote()) {
            if (note >= this.maxMidiOverflow()) {
                throw new MidiOutOfRangeException();
            }
            if (this.instrument.getPitch() != maxPitch) {
                this.overflowMidi(maxPitch);
            }
        }
        if (this.instrument.getPitch() == minPitch) {
            if (note >= this.minMidiNote()) {
                this.instrument.setPitch(0);
            } else {
                note += 12;
            }
        } else if (this.instrument.getPitch() == maxPitch) {
            if (note < this.maxMidiNote()) {
                this.instrument.setPitch(0);
            } else {
                note -= 12;
            }
        }
        return note;
    }

    private void overflowMidi(int desiredPitch) {
        this.instrument.setPitch(desiredPitch);
        if (!((Integer)ModClientConfigs.PITCH.get()).equals(0)) {
            ModClientConfigs.PITCH.set((Object)0);
        }
    }

    protected int minMidiNote() {
        return 0;
    }

    protected int maxMidiNote() {
        return NoteSound.MAX_PITCH * 3;
    }

    public boolean allowMidiOverflow() {
        return false;
    }

    protected int maxMidiOverflow() {
        return this.maxMidiNote() + 12;
    }

    protected int minMidiOverflow() {
        return this.minMidiNote() - 12;
    }

    protected int getLowC(int note) {
        return note - (Integer)ModClientConfigs.OCTAVE_SHIFT.get() * 12 - 48;
    }
}

