/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.client.keyMaps;

import com.cstav.genshinstrument.client.gui.screen.instrument.partial.InstrumentScreen;
import com.mojang.blaze3d.platform.InputConstants;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, modid="genshinstrument", value={Dist.CLIENT})
public class InstrumentKeyMappings {
    public static final String CATEGORY = "genshinstrument.keymaps";
    public static final IKeyConflictContext INSTRUMENT_KEY_CONFLICT_CONTEXT = new IKeyConflictContext(){

        public boolean isActive() {
            return Minecraft.m_91087_().f_91080_ instanceof InstrumentScreen;
        }

        public boolean conflicts(IKeyConflictContext other) {
            return this == other;
        }
    };
    public static final Lazy<KeyMapping> TRANSPOSE_UP_MODIFIER = Lazy.of(() -> new KeyMapping("genshinstrument.keymaps.transpose_up_modifier", INSTRUMENT_KEY_CONFLICT_CONTEXT, InputConstants.Type.KEYSYM, 340, CATEGORY));
    public static final Lazy<KeyMapping> TRANSPOSE_DOWN_MODIFIER = Lazy.of(() -> new KeyMapping("genshinstrument.keymaps.transpose_down_modifier", INSTRUMENT_KEY_CONFLICT_CONTEXT, InputConstants.Type.KEYSYM, 342, CATEGORY));
    public static final InputConstants.Key[][] GRID_INSTRUMENT_MAPPINGS = InstrumentKeyMappings.createInstrumentMaps(new int[][]{{81, 87, 69, 82, 84, 89, 85, 73}, {65, 83, 68, 70, 71, 72, 74, 75}, {90, 88, 67, 86, 66, 78, 77, 44}});
    public static final DrumKeys DON = new DrumKeys(83, 75);
    public static final DrumKeys KA = new DrumKeys(65, 76);

    @SubscribeEvent
    public static void registerKeybinds(RegisterKeyMappingsEvent event) {
        event.register((KeyMapping)TRANSPOSE_UP_MODIFIER.get());
        event.register((KeyMapping)TRANSPOSE_DOWN_MODIFIER.get());
    }

    public static InputConstants.Key[][] createInstrumentMaps(int[][] keyCodes) {
        int rows = keyCodes[0].length;
        int columns = keyCodes.length;
        InputConstants.Key[][] result = new InputConstants.Key[columns][rows];
        for (int i = 0; i < columns; ++i) {
            for (int j = 0; j < rows; ++j) {
                result[i][j] = InstrumentKeyMappings.create(keyCodes[i][j]);
            }
        }
        return result;
    }

    private static InputConstants.Key create(int keyCode) {
        return InputConstants.Type.KEYSYM.m_84895_(keyCode);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final class DrumKeys {
        public final InputConstants.Key left;
        public final InputConstants.Key right;

        private DrumKeys(int left, int right) {
            this.left = InstrumentKeyMappings.create(left);
            this.right = InstrumentKeyMappings.create(right);
        }

        public InputConstants.Key getKey(boolean isRight) {
            return isRight ? this.right : this.left;
        }
    }
}

