/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.client.gui.screen.options.instrument.partial;

import com.cstav.genshinstrument.client.config.ModClientConfigs;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.InstrumentScreen;
import com.mojang.logging.LogUtils;
import java.awt.Color;
import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public abstract class AbstractInstrumentOptionsScreen
extends Screen {
    @Nullable
    public final InstrumentScreen instrumentScreen;
    public final Screen lastScreen;
    public final boolean isOverlay;
    protected final HashMap<String, Runnable> appliedOptions = new HashMap();
    private static final Logger LOGGER = LogUtils.getLogger();

    public AbstractInstrumentOptionsScreen(Component pTitle, InstrumentScreen instrumentScreen, Screen lastScreen) {
        super(pTitle);
        this.instrumentScreen = instrumentScreen;
        this.lastScreen = lastScreen;
        this.isOverlay = instrumentScreen != null;
    }

    public AbstractInstrumentOptionsScreen(Component pTitle, InstrumentScreen instrumentScreen) {
        this(pTitle, instrumentScreen, null);
    }

    public AbstractInstrumentOptionsScreen(Component pTitle, Screen prevScreen) {
        this(pTitle, null, prevScreen);
    }

    public int getSmallButtonWidth() {
        return 190;
    }

    public int getBigButtonWidth() {
        return (this.getSmallButtonWidth() + 4) * 2;
    }

    public int getButtonHeight() {
        return 20;
    }

    public void m_88315_(GuiGraphics gui, int pMouseX, int pMouseY, float pPartialTick) {
        this.m_280273_(gui);
        gui.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 15, Color.WHITE.getRGB());
        super.m_88315_(gui, pMouseX, pMouseY, pPartialTick);
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        if (this.isOverlay && this.instrumentScreen.isKeyConsumed(pKeyCode, pScanCode)) {
            this.instrumentScreen.m_7933_(pKeyCode, pScanCode, pModifiers);
        }
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }

    public boolean m_7920_(int pKeyCode, int pScanCode, int pModifiers) {
        if (this.isOverlay && this.instrumentScreen.isKeyConsumed(pKeyCode, pScanCode)) {
            this.instrumentScreen.m_7920_(pKeyCode, pScanCode, pModifiers);
        }
        return super.m_7920_(pKeyCode, pScanCode, pModifiers);
    }

    public boolean m_7043_() {
        return this.instrumentScreen == null;
    }

    public void m_7379_() {
        this.saveOptions();
        if (this.isOverlay) {
            super.m_7379_();
            if (this.lastScreen != null) {
                this.f_96541_.pushGuiLayer(this.lastScreen);
            }
        } else if (this.lastScreen != null) {
            this.f_96541_.m_91152_(this.lastScreen);
        } else {
            super.m_7379_();
        }
    }

    protected void queueToSave(String optionKey, Runnable saveRunnable) {
        String modId = this.modId();
        if (modId != null) {
            optionKey = modId + ":" + (String)optionKey;
        }
        if (this.appliedOptions.containsKey(optionKey)) {
            this.appliedOptions.replace((String)optionKey, saveRunnable);
        } else {
            this.appliedOptions.put((String)optionKey, saveRunnable);
        }
    }

    protected void saveOptions() {
        if (this.appliedOptions.isEmpty()) {
            return;
        }
        this.appliedOptions.values().forEach(Runnable::run);
        ModClientConfigs.CONFIGS.save();
        LOGGER.info("Successfully saved " + this.appliedOptions.size() + " option(s) for " + this.f_96539_.getString());
    }

    public String modId() {
        return this.isOverlay ? this.instrumentScreen.getModId() : null;
    }
}

