/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.client.gui.screen.options.instrument.midi;

import com.cstav.genshinstrument.client.config.ModClientConfigs;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.InstrumentScreen;
import com.cstav.genshinstrument.client.gui.screen.options.instrument.partial.AbstractInstrumentOptionsScreen;
import com.cstav.genshinstrument.client.gui.widget.SliderButton;
import com.cstav.genshinstrument.client.midi.MidiController;
import com.cstav.genshinstrument.client.util.ClientUtil;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.Layout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.SpacerElement;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MidiOptionsScreen
extends AbstractInstrumentOptionsScreen {
    public static final int MIN_OCTAVE_SHIFT = -5;
    public static final int MAX_OCTAVE_SHIFT = 5;
    public static final int MIN_MIDI_CHANNEL = 0;
    public static final int MAX_MIDI_CHANNEL = 15;

    public MidiOptionsScreen(Component pTitle, Screen prevScreen, InstrumentScreen instrumentScreen) {
        super(pTitle, instrumentScreen, prevScreen);
    }

    protected void m_7856_() {
        GridLayout grid = new GridLayout();
        grid.m_264211_().m_264414_(4, 2).m_264221_(0.5f).m_264356_();
        this.initOptionsGrid(grid, grid.m_264606_(2));
        ClientUtil.alignGrid((Layout)grid, this.f_96543_, this.f_96544_);
        grid.m_264134_(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.m_142416_((GuiEventListener)x$0);
        });
        Button doneBtn = Button.m_253074_((Component)CommonComponents.f_130655_, btn -> this.m_7379_()).m_252780_(150).m_252794_((this.f_96543_ - 150) / 2, ClientUtil.lowerButtonsY(grid.m_252907_(), grid.m_93694_(), this.f_96544_)).m_253136_();
        this.m_142416_((GuiEventListener)doneBtn);
    }

    protected void initDeviceSection(GridLayout grid, GridLayout.RowHelper rowHelper) {
        CycleButton midiEnabled = CycleButton.m_168896_((Component)CommonComponents.f_130653_, (Component)CommonComponents.f_130654_).m_168948_((Object)((Boolean)ModClientConfigs.MIDI_ENABLED.get())).m_168936_(0, 0, this.getSmallButtonWidth(), this.getButtonHeight(), (Component)Component.m_237115_((String)"button.genshinstrument.midiEnabled"), this::onMidiEnabledChanged);
        rowHelper.m_264139_((LayoutElement)midiEnabled);
        CycleButton fixedTouch = CycleButton.m_168896_((Component)CommonComponents.f_130653_, (Component)CommonComponents.f_130654_).m_168948_((Object)((Boolean)ModClientConfigs.FIXED_TOUCH.get())).m_232498_(value -> Tooltip.m_257550_((Component)Component.m_237115_((String)"button.genshinstrument.fixedTouch.tooltip"))).m_168936_(0, 0, this.getSmallButtonWidth(), this.getButtonHeight(), (Component)Component.m_237115_((String)"button.genshinstrument.fixedTouch"), this::onFixedTouchChanged);
        rowHelper.m_264139_((LayoutElement)fixedTouch);
        MidiController.reloadDevices();
        CycleButton midiDevice = CycleButton.m_168894_(value -> {
            if (value == -1) {
                return Component.m_237115_((String)"button.none");
            }
            return Component.m_237113_((String)MidiController.infoAsString(MidiController.getInfoFromIndex(value)));
        }).m_232502_(MidiController.getValuesForOption()).m_168948_((Object)((Integer)ModClientConfigs.MIDI_DEVICE_INDEX.get())).m_168936_(0, 0, this.getBigButtonWidth(), this.getButtonHeight(), (Component)Component.m_237115_((String)"button.genshinstrument.midiDevice"), this::onMidiDeviceChanged);
        rowHelper.m_264108_((LayoutElement)midiDevice, 2);
    }

    protected void initThatOtherSection(GridLayout grid, GridLayout.RowHelper rowHelper) {
        boolean canInstrumentOverflow;
        boolean bl = canInstrumentOverflow = !this.isOverlay || this.instrumentScreen.midiReceiver.allowMidiOverflow();
        if (canInstrumentOverflow) {
            CycleButton extendOctaves = CycleButton.m_168896_((Component)CommonComponents.f_130653_, (Component)CommonComponents.f_130654_).m_168948_((Object)((Boolean)ModClientConfigs.EXTEND_OCTAVES.get())).m_232498_(value -> Tooltip.m_257550_((Component)Component.m_237115_((String)"button.genshinstrument.extendOctaves.tooltip"))).m_168936_(0, 0, this.getSmallButtonWidth(), this.getButtonHeight(), (Component)Component.m_237115_((String)"button.genshinstrument.extendOctaves"), this::onExtendOctavesChanged);
            rowHelper.m_264139_((LayoutElement)extendOctaves);
        }
        SliderButton octaveShift = new SliderButton(canInstrumentOverflow ? this.getSmallButtonWidth() : this.getBigButtonWidth(), ((Integer)ModClientConfigs.OCTAVE_SHIFT.get()).intValue(), -5.0, 5.0){

            @Override
            public Component m_6035_() {
                return Component.m_237115_((String)"button.genshinstrument.midiOctaveShift").m_130946_(": " + ModClientConfigs.OCTAVE_SHIFT.get());
            }

            protected void m_5697_() {
                MidiOptionsScreen.this.onOctaveShiftChanged(this, (int)this.getValueClamped());
            }
        };
        rowHelper.m_264108_((LayoutElement)octaveShift, canInstrumentOverflow ? 1 : 2);
        SliderButton midiChannel = new SliderButton(this.getSmallButtonWidth(), ((Integer)ModClientConfigs.MIDI_CHANNEL.get()).intValue(), 0.0, 15.0){

            @Override
            public Component m_6035_() {
                return Component.m_237115_((String)"button.genshinstrument.midiChannel").m_130946_(": " + ModClientConfigs.MIDI_CHANNEL.get());
            }

            protected void m_5697_() {
                MidiOptionsScreen.this.onMidiChannelChanged(this, (int)this.getValueClamped());
            }
        };
        CycleButton acceptAllChannels = CycleButton.m_168896_((Component)CommonComponents.f_130653_, (Component)CommonComponents.f_130654_).m_168948_((Object)((Boolean)ModClientConfigs.ACCEPT_ALL_CHANNELS.get())).m_168936_(0, 0, this.getSmallButtonWidth(), this.getButtonHeight(), (Component)Component.m_237115_((String)"button.genshinstrument.acceptAllChannels"), (btn, val) -> {
            this.onAcceptAllChannelsChanged((CycleButton<Boolean>)btn, (boolean)val);
            midiChannel.f_93623_ = val == false;
        });
        midiChannel.f_93623_ = (Boolean)acceptAllChannels.m_168883_() == false;
        rowHelper.m_264139_((LayoutElement)acceptAllChannels);
        rowHelper.m_264139_((LayoutElement)midiChannel);
    }

    protected void initOptionsGrid(GridLayout grid, GridLayout.RowHelper rowHelper) {
        this.initDeviceSection(grid, rowHelper);
        rowHelper.m_264108_((LayoutElement)SpacerElement.m_264252_((int)7), 2);
        this.initThatOtherSection(grid, rowHelper);
    }

    protected void onMidiEnabledChanged(CycleButton<Boolean> button, boolean value) {
        if (!value) {
            MidiController.unloadDevice();
        } else {
            MidiController.openForListen();
        }
        ModClientConfigs.MIDI_ENABLED.set((Object)value);
    }

    protected void onMidiDeviceChanged(CycleButton<Integer> button, int value) {
        if (value == -1) {
            MidiController.unloadDevice();
        } else {
            MidiController.loadDevice(value);
            if (((Boolean)ModClientConfigs.MIDI_ENABLED.get()).booleanValue()) {
                MidiController.openForListen();
            }
        }
        this.queueToSave("midi_device_index", () -> this.saveMidiDeviceIndex(value));
    }

    protected void saveMidiDeviceIndex(int index) {
        ModClientConfigs.MIDI_DEVICE_INDEX.set((Object)index);
    }

    protected void onExtendOctavesChanged(CycleButton<Boolean> button, boolean value) {
        ModClientConfigs.EXTEND_OCTAVES.set((Object)value);
    }

    protected void onOctaveShiftChanged(AbstractSliderButton button, int value) {
        if ((Integer)ModClientConfigs.OCTAVE_SHIFT.get() != value) {
            ModClientConfigs.OCTAVE_SHIFT.set((Object)value);
        }
    }

    protected void onFixedTouchChanged(CycleButton<Boolean> button, boolean value) {
        ModClientConfigs.FIXED_TOUCH.set((Object)value);
    }

    protected void onAcceptAllChannelsChanged(CycleButton<Boolean> button, boolean value) {
        ModClientConfigs.ACCEPT_ALL_CHANNELS.set((Object)value);
    }

    protected void onMidiChannelChanged(AbstractSliderButton button, int value) {
        if ((Integer)ModClientConfigs.MIDI_CHANNEL.get() != value) {
            ModClientConfigs.MIDI_CHANNEL.set((Object)value);
        }
    }
}

