/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.client.gui.screen.instrument.partial.notegrid;

import com.cstav.genshinstrument.client.config.ModClientConfigs;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.InstrumentScreen;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.NoteButton;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.NoteButtonRenderer;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.notegrid.GridInstrumentScreen;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.notegrid.NoteGrid;
import com.cstav.genshinstrument.client.keyMaps.InstrumentKeyMappings;
import com.cstav.genshinstrument.networking.buttonidentifier.NoteGridButtonIdentifier;
import com.cstav.genshinstrument.sound.NoteSound;
import com.cstav.genshinstrument.util.LabelUtil;
import com.mojang.blaze3d.platform.InputConstants;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class NoteGridButton
extends NoteButton {
    private static final ResourceLocation[] GRID_LABELS = new ResourceLocation[LabelUtil.ABC.length];
    public final int row;
    public final int column;

    public NoteGridButton(int row, int column, GridInstrumentScreen instrumentScreen) {
        super(NoteGridButton.getSoundFromArr(instrumentScreen, instrumentScreen.getInitSounds(), row, column), instrumentScreen.getInitLabelSupplier(), instrumentScreen);
        this.row = row;
        this.column = column;
    }

    public NoteGridButton(int row, int column, GridInstrumentScreen instrumentScreen, int pitch) {
        super(instrumentScreen.getInitSounds()[0], instrumentScreen.getInitLabelSupplier(), instrumentScreen, pitch);
        this.row = row;
        this.column = column;
    }

    public GridInstrumentScreen gridInstrument() {
        return (GridInstrumentScreen)this.instrumentScreen;
    }

    public void updateSoundArr() {
        InstrumentScreen instrumentScreen = this.instrumentScreen;
        if (!(instrumentScreen instanceof GridInstrumentScreen)) {
            return;
        }
        GridInstrumentScreen gridInstrument = (GridInstrumentScreen)instrumentScreen;
        NoteGrid grid = gridInstrument.noteGrid;
        NoteSound[] sounds = grid.getNoteSounds();
        this.setSound(gridInstrument.isSSTI() ? sounds[0] : NoteGridButton.getSoundFromArr(gridInstrument, sounds, this.row, this.column));
    }

    public static NoteSound getSoundFromArr(GridInstrumentScreen gridInstrument, NoteSound[] sounds, int row, int column) {
        return sounds[row + NoteGrid.getFlippedColumn(column, gridInstrument.columns()) * gridInstrument.rows()];
    }

    public InputConstants.Key getKey() {
        return InstrumentKeyMappings.GRID_INSTRUMENT_MAPPINGS[this.column][this.row];
    }

    @Override
    public NoteGridButtonIdentifier getIdentifier() {
        return new NoteGridButtonIdentifier(this);
    }

    @Override
    protected NoteButtonRenderer initNoteRenderer() {
        return new NoteButtonRenderer(this, () -> GRID_LABELS[this.textureRow()]);
    }

    protected int textureRow() {
        return (Boolean)ModClientConfigs.ACCURATE_NOTES.get() != false ? this.getABCOffset() : this.row % GRID_LABELS.length;
    }

    @Override
    public int getNoteOffset() {
        return this.row + this.column * this.gridInstrument().rows();
    }

    static {
        for (int i = 0; i < LabelUtil.ABC.length; ++i) {
            NoteGridButton.GRID_LABELS[i] = InstrumentScreen.getInternalResourceFromGlob("note/label/grid/" + Character.toLowerCase(LabelUtil.ABC[i]) + ".png");
        }
    }
}

