/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.client.gui.screen.instrument.partial.notegrid;

import com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.NoteButton;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.notegrid.GridInstrumentScreen;
import com.cstav.genshinstrument.client.midi.InstrumentMidiReceiver;

public class GridInstrumentMidiReceiver
extends InstrumentMidiReceiver {
    public GridInstrumentMidiReceiver(GridInstrumentScreen instrument) {
        super(instrument);
    }

    @Override
    public boolean allowMidiOverflow() {
        return true;
    }

    @Override
    protected NoteButton handleMidiPress(int note, int key) {
        GridInstrumentScreen instrumentScreen = (GridInstrumentScreen)this.instrument;
        int layoutNote = note % 12;
        boolean higherThan3 = layoutNote > key + 4;
        boolean shouldSharpen = this.shouldSharpen(layoutNote, key);
        boolean shouldFlatten = this.shouldFlatten(shouldSharpen);
        this.transposeMidi(shouldSharpen, shouldFlatten);
        int playedNote = note + (shouldFlatten ? 1 : (shouldSharpen ? -1 : 0));
        int currNote = (playedNote + (higherThan3 ? 1 : 0)) / 2 + playedNote / (12 + key);
        return instrumentScreen.getNoteButton(currNote % instrumentScreen.rows(), currNote / instrumentScreen.rows());
    }
}

