/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.animation;

import com.cstav.genshinstrument.client.AnimationController;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.NoteRing;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RingAnimationController
extends AnimationController {
    protected final double initSize;
    protected final float initAlpha = -0.08f;
    protected final NoteRing ring;
    protected final float ringSizeMultiplier;
    private double dSize;

    public RingAnimationController(float duration, float ringSizeMultiplier, NoteRing ring) {
        super(duration, 1.1f);
        this.ringSizeMultiplier = ringSizeMultiplier;
        this.ring = ring;
        this.initSize = (double)ring.note.instrumentScreen.getNoteSize() * 0.8;
    }

    @Override
    protected void animFrame(float targetTime, float deltaValue) {
        this.ring.size = (int)(this.dSize += (double)(deltaValue * this.ringSizeMultiplier));
        this.ring.alpha = (float)this.getAnimTime() < targetTime / 1.75f ? (this.ring.alpha += deltaValue * 1.5f) : (this.ring.alpha -= deltaValue);
    }

    @Override
    protected void resetAnimVars() {
        super.resetAnimVars();
        this.dSize = this.initSize;
        this.ring.size = (int)this.dSize;
        this.ring.alpha = -0.08f;
    }

    public void play(float initAlpha) {
        this.play();
        this.ring.alpha = initAlpha;
    }
}

