/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.client.gui.screen.instrument.partial.note;

import com.cstav.genshinstrument.client.gui.screen.instrument.partial.InstrumentScreen;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.InstrumentThemeLoader;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.NoteButton;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.NoteRing;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.animation.NoteAnimationController;
import com.cstav.genshinstrument.client.util.ClientUtil;
import com.cstav.genshinstrument.util.CommonUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;

public class NoteButtonRenderer {
    private static final Minecraft MINECRAFT = Minecraft.m_91087_();
    private static final double SHARP_MULTIPLIER = 0.9;
    public final NoteButton noteButton;
    protected final InstrumentScreen instrumentScreen;
    protected final ResourceLocation rootLocation;
    protected final ResourceLocation accidentalsLocation;
    protected final ResourceLocation notePressedLocation;
    protected final ResourceLocation noteReleasedLocation;
    protected final ResourceLocation noteHoverLocation;
    protected Supplier<ResourceLocation> noteTextureProvider;
    public final NoteAnimationController noteAnimation;
    private boolean foreignPlaying = false;
    protected final ArrayList<NoteRing> rings = new ArrayList();
    private int labelX;
    private int labelY;

    public NoteButtonRenderer(NoteButton noteButton, Supplier<ResourceLocation> noteTextureProvider) {
        this.noteButton = noteButton;
        this.noteTextureProvider = noteTextureProvider;
        this.instrumentScreen = noteButton.instrumentScreen;
        this.noteAnimation = new NoteAnimationController(0.15f, 9.0f, noteButton);
        this.rootLocation = this.instrumentScreen.getResourceFromRoot("note");
        this.accidentalsLocation = this.getResourceFromRoot("accidentals.png");
        this.notePressedLocation = this.getResourceFromRoot("note/pressed.png");
        this.noteReleasedLocation = this.getResourceFromRoot("note/released.png");
        this.noteHoverLocation = this.getResourceFromRoot("note/hovered.png");
    }

    public void render(GuiGraphics gui, int mouseX, int mouseY, float partialTick, InstrumentThemeLoader themeLoader) {
        RenderSystem.enableBlend();
        this.rings.removeIf(ring -> !ring.isPlaying());
        this.rings.forEach(ring -> ring.render(gui, themeLoader));
        this.renderNoteButton(gui, themeLoader);
        this.renderNote(gui, themeLoader);
        this.renderLabel(gui, themeLoader);
        this.renderAccidentals(gui, themeLoader);
        this.noteAnimation.update();
    }

    protected void renderNoteButton(GuiGraphics gui, InstrumentThemeLoader themeLoader) {
        ResourceLocation noteLocation = this.noteButton.isPlaying() ? (this.foreignPlaying ? this.noteHoverLocation : this.notePressedLocation) : (this.noteButton.m_198029_() ? this.noteHoverLocation : this.noteReleasedLocation);
        gui.m_280163_(noteLocation, this.noteButton.m_252754_(), this.noteButton.m_252907_(), 0.0f, 0.0f, this.noteButton.m_5711_(), this.noteButton.m_93694_(), this.noteButton.m_5711_(), this.noteButton.m_93694_());
    }

    protected void renderNote(GuiGraphics gui, InstrumentThemeLoader themeLoader) {
        int noteWidth = this.noteButton.m_5711_() / 2;
        int noteHeight = this.noteButton.m_93694_() / 2;
        ClientUtil.setShaderColor(this.noteButton.isPlaying() && !this.foreignPlaying ? themeLoader.notePressed() : themeLoader.noteReleased());
        gui.m_280163_(this.noteTextureProvider.get(), this.noteButton.m_252754_() + noteWidth / 2, this.noteButton.m_252907_() + noteHeight / 2, 0.0f, 0.0f, noteWidth, noteHeight, noteWidth, this.noteButton.m_93694_() / 2);
        ClientUtil.resetShaderColor();
    }

    public void setLabelX(int labelX) {
        this.labelX = labelX;
    }

    public void setLabelY(int labelY) {
        this.labelY = labelY;
    }

    protected void renderLabel(GuiGraphics gui, InstrumentThemeLoader themeLoader) {
        gui.m_280653_(NoteButtonRenderer.MINECRAFT.f_91062_, this.noteButton.m_6035_(), this.labelX, this.labelY, (this.noteButton.isPlaying() && !this.foreignPlaying ? themeLoader.labelPressed() : themeLoader.labelReleased()).getRGB());
    }

    protected void renderAccidentals(GuiGraphics gui, InstrumentThemeLoader themeLoader) {
        RenderSystem.enableBlend();
        switch (this.noteButton.getNotation()) {
            case NONE: {
                break;
            }
            case FLAT: {
                this.renderAccidental(gui, 0);
                break;
            }
            case SHARP: {
                this.renderAccidental(gui, 1);
                break;
            }
            case DOUBLE_FLAT: {
                this.renderAccidental(gui, 0, -6, -3);
                this.renderAccidental(gui, 0, 5, 2);
                break;
            }
            case DOUBLE_SHARP: {
                this.renderAccidental(gui, 2, -1, 0);
            }
        }
    }

    protected void renderAccidental(GuiGraphics gui, int index) {
        this.renderAccidental(gui, index, 0, 0);
    }

    protected void renderAccidental(GuiGraphics gui, int index, int offsetX, int offsetY) {
        double textureMultiplier = (double)this.noteButton.m_5711_() * (index == 1 ? 0.9 : 1.0) * 2.0;
        int textureWidth = (int)textureMultiplier;
        int textureHeight = (int)textureMultiplier - 1;
        int spritePartWidth = textureWidth / 3 + 1;
        gui.m_280163_(this.accidentalsLocation, this.noteButton.m_252754_() - 9 + offsetX, this.noteButton.m_252907_() - 5 + offsetY, (float)(spritePartWidth * index), this.noteButton.isPlaying() ? (float)((textureHeight + 1) / 2) : 0.0f, spritePartWidth - 1, textureHeight / 2, textureWidth, textureHeight);
    }

    public void playNoteAnimation(boolean isForeign) {
        this.foreignPlaying = isForeign;
        this.noteAnimation.play(isForeign);
        this.rings.add(new NoteRing(this.noteButton, isForeign));
    }

    protected ResourceLocation getResourceFromRoot(String path) {
        return CommonUtil.getResourceFrom(this.rootLocation, path);
    }
}

