/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.client.gui.screen.instrument.drum;

import com.cstav.genshinstrument.client.config.ModClientConfigs;
import com.cstav.genshinstrument.client.config.enumType.label.DrumNoteLabel;
import com.cstav.genshinstrument.client.gui.screen.instrument.drum.AratakisGreatAndGloriousDrumScreen;
import com.cstav.genshinstrument.client.gui.screen.instrument.drum.DrumButtonType;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.NoteButton;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.NoteButtonRenderer;
import com.cstav.genshinstrument.networking.buttonidentifier.DrumNoteIdentifier;
import com.mojang.blaze3d.platform.InputConstants;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DrumNoteButton
extends NoteButton {
    public final DrumButtonType btnType;
    public final boolean isRight;

    public DrumNoteButton(DrumButtonType btnType, boolean isRight, AratakisGreatAndGloriousDrumScreen drumScreen) {
        super(btnType.getSound(), ((DrumNoteLabel)ModClientConfigs.DRUM_LABEL_TYPE.get()).getLabelSupplier(), drumScreen);
        this.btnType = btnType;
        this.isRight = isRight;
    }

    @Override
    public DrumNoteIdentifier getIdentifier() {
        return new DrumNoteIdentifier(this);
    }

    public InputConstants.Key getKey() {
        return this.btnType.getKeys().getKey(this.isRight);
    }

    @Override
    protected NoteButtonRenderer initNoteRenderer() {
        return new NoteButtonRenderer(this, () -> this.instrumentScreen.getResourceFromRoot("note/label/" + (String)(switch (this.btnType) {
            default -> throw new IncompatibleClassChangeError();
            case DrumButtonType.DON -> "don";
            case DrumButtonType.KA -> "ka_" + (this.isRight ? "right" : "left");
        }) + ".png", false));
    }

    @Override
    public int getNoteOffset() {
        return this.btnType == DrumButtonType.DON ? 0 : 1;
    }
}

