/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.client.gui.screen.instrument.drum;

import com.cstav.genshinstrument.client.config.ModClientConfigs;
import com.cstav.genshinstrument.client.gui.screen.instrument.drum.DominantDrumType;
import com.cstav.genshinstrument.client.gui.screen.instrument.drum.DrumButtonType;
import com.cstav.genshinstrument.client.gui.screen.instrument.drum.DrumNoteButton;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.InstrumentScreen;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.InstrumentThemeLoader;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.NoteButton;
import com.cstav.genshinstrument.client.gui.screen.options.instrument.DrumOptionsScren;
import com.cstav.genshinstrument.client.gui.screen.options.instrument.partial.InstrumentOptionsScreen;
import com.cstav.genshinstrument.client.midi.InstrumentMidiReceiver;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.Mod;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class AratakisGreatAndGloriousDrumScreen
extends InstrumentScreen {
    public static final ResourceLocation INSTRUMENT_ID = new ResourceLocation("genshinstrument", "glorious_drum");
    public static final String[] NOTE_LAYOUT = new String[]{"D", "G"};
    private final HashMap<InputConstants.Key, NoteButton> notes = new HashMap();
    private static final InstrumentThemeLoader THEME_LOADER = new InstrumentThemeLoader(INSTRUMENT_ID);

    @Override
    public ResourceLocation getInstrumentId() {
        return INSTRUMENT_ID;
    }

    @Override
    public Map<InputConstants.Key, NoteButton> noteMap() {
        return this.notes;
    }

    @Override
    protected InstrumentOptionsScreen initInstrumentOptionsScreen() {
        return new DrumOptionsScren(this);
    }

    @Override
    protected void m_7856_() {
        this.initOptionsButton(this.f_96544_ / 2 + 25);
        LinearLayout layout1 = this.createRow(DrumButtonType.DON, 2.0f);
        LinearLayout layout2 = this.createRow(DrumButtonType.KA, 1.3f);
        layout1.m_264036_();
        layout2.m_264036_();
        layout1.m_264152_((this.f_96543_ - layout1.m_5711_()) / 2, (int)((float)this.f_96544_ * 0.8f));
        layout2.m_264152_((this.f_96543_ - layout2.m_5711_()) / 2, layout1.m_252907_() - layout1.m_93694_() / 2);
        layout1.m_264036_();
        layout2.m_264036_();
        layout1.m_264134_(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.m_142416_((GuiEventListener)x$0);
        });
        layout2.m_264134_(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.m_142416_((GuiEventListener)x$0);
        });
        this.notesIterable().forEach(NoteButton::init);
        super.m_7856_();
    }

    private LinearLayout createRow(DrumButtonType type, float widthPercent) {
        LinearLayout layout = new LinearLayout(0, 0, (int)((float)this.f_96543_ / widthPercent), this.getNoteSize(), LinearLayout.Orientation.HORIZONTAL);
        this.createButton(type, layout, false);
        this.createButton(type, layout, true);
        return layout;
    }

    private DrumNoteButton createButton(DrumButtonType btnType, LinearLayout container, boolean isRight) {
        DrumNoteButton btn = new DrumNoteButton(btnType, isRight, this);
        container.m_264406_((LayoutElement)btn);
        this.notes.put(btn.getKey(), btn);
        return btn;
    }

    @Override
    public String[] noteLayout() {
        return NOTE_LAYOUT;
    }

    @Override
    public InstrumentThemeLoader getThemeLoader() {
        return THEME_LOADER;
    }

    @Override
    public InstrumentMidiReceiver initMidiReceiver() {
        return new InstrumentMidiReceiver(this){
            private static boolean donRight = false;
            private static boolean kaRight = false;

            @Override
            protected NoteButton handleMidiPress(int note, int key) {
                boolean isKa = AratakisGreatAndGloriousDrumScreen.ddt() == DominantDrumType.KA || AratakisGreatAndGloriousDrumScreen.ddt() == DominantDrumType.BOTH && note >= 12;
                AratakisGreatAndGloriousDrumScreen.this.setPitch(note - (isKa ? 19 : 2));
                for (NoteButton noteButton : AratakisGreatAndGloriousDrumScreen.this.notesIterable()) {
                    DrumNoteButton dnb = (DrumNoteButton)noteButton;
                    if (dnb.btnType != (isKa ? DrumButtonType.KA : DrumButtonType.DON)) continue;
                    if (isKa) {
                        if (dnb.isRight != kaRight) continue;
                        kaRight = !kaRight;
                        return dnb;
                    }
                    if (dnb.isRight != donRight) continue;
                    donRight = !donRight;
                    return dnb;
                }
                return null;
            }

            @Override
            protected int minMidiNote() {
                return AratakisGreatAndGloriousDrumScreen.ddt() == DominantDrumType.BOTH || AratakisGreatAndGloriousDrumScreen.ddt() == DominantDrumType.DON ? -10 : 7;
            }

            @Override
            protected int maxMidiNote() {
                return AratakisGreatAndGloriousDrumScreen.ddt() == DominantDrumType.BOTH || AratakisGreatAndGloriousDrumScreen.ddt() == DominantDrumType.KA ? 32 : 15;
            }
        };
    }

    private static final DominantDrumType ddt() {
        return (DominantDrumType)((Object)ModClientConfigs.DOMINANT_DRUM_TYPE.get());
    }
}

