/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.client;

import net.minecraft.client.Minecraft;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class AnimationController {
    protected final Minecraft minecraft = Minecraft.m_91087_();
    private int animTime;
    private boolean isPlaying;
    public final float initDuration;
    public final float initTargetValue;
    protected float duration;
    protected float targetValue;

    public AnimationController(float duration, float targetValue) {
        this.duration = this.initDuration = duration;
        this.targetValue = this.initTargetValue = targetValue;
    }

    public int getAnimTime() {
        return this.animTime;
    }

    public void update() {
        if (!this.isPlaying()) {
            return;
        }
        int fps = this.minecraft.m_260875_();
        float targetTime = (float)fps * this.duration;
        int n = this.animTime++;
        if ((float)n >= targetTime) {
            this.stop();
            return;
        }
        this.animFrame(targetTime, this.targetValue / targetTime);
    }

    protected abstract void animFrame(float var1, float var2);

    public void stop() {
        this.resetAnimVars();
        this.isPlaying = false;
    }

    public void play() {
        this.resetAnimVars();
        this.isPlaying = true;
    }

    public void play(float duration, float targetValue) {
        this.duration = duration;
        this.targetValue = targetValue;
    }

    protected void resetAnimVars() {
        this.duration = this.initDuration;
        this.targetValue = this.initTargetValue;
        this.animTime = 0;
    }

    public boolean isPlaying() {
        return this.isPlaying;
    }
}

