/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.capability.instrumentOpen;

import com.cstav.genshinstrument.capability.instrumentOpen.InstrumentOpen;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstrumentOpenProvider
implements ICapabilityProvider,
INBTSerializable<CompoundTag> {
    public static final Capability<InstrumentOpen> INSTRUMENT_OPEN = CapabilityManager.get((CapabilityToken)new CapabilityToken<InstrumentOpen>(){});
    private InstrumentOpen instrumentOpen;
    private final LazyOptional<InstrumentOpen> optional = LazyOptional.of(this::getInstance);

    @NotNull
    private InstrumentOpen getInstance() {
        return this.instrumentOpen == null ? (this.instrumentOpen = new InstrumentOpen()) : this.instrumentOpen;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return INSTRUMENT_OPEN.orEmpty(cap, this.optional);
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        this.getInstance().saveNBTData(nbt);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.getInstance().loadNBTData(nbt);
    }

    public static void setOpen(Player player, BlockPos pos) {
        player.getCapability(INSTRUMENT_OPEN).ifPresent(instrumentOpen -> instrumentOpen.setOpen(pos));
    }

    public static void setOpen(Player player, InteractionHand hand) {
        player.getCapability(INSTRUMENT_OPEN).ifPresent(instrumentOpen -> instrumentOpen.setOpen(hand));
    }

    public static void setClosed(Player player) {
        player.getCapability(INSTRUMENT_OPEN).ifPresent(InstrumentOpen::setClosed);
    }

    public static void setBlockPos(Player player, BlockPos blockPos) {
        player.getCapability(INSTRUMENT_OPEN).ifPresent(instrumentOpen -> instrumentOpen.setBlockPos(blockPos));
    }

    public static boolean isOpen(Player player) {
        return InstrumentOpenProvider.getInstrumentOpen(player, InstrumentOpen::isOpen, false);
    }

    public static boolean isItem(Player player) {
        return InstrumentOpenProvider.getInstrumentOpen(player, InstrumentOpen::isItem, false);
    }

    public static BlockPos getBlockPos(Player player) {
        return InstrumentOpenProvider.getInstrumentOpen(player, InstrumentOpen::getBlockPos, null);
    }

    public static InteractionHand getHand(Player player) {
        return InstrumentOpenProvider.getInstrumentOpen(player, InstrumentOpen::getHand, null);
    }

    private static <T> T getInstrumentOpen(Player player, Function<InstrumentOpen, T> ifExists, T elseVal) {
        LazyOptional lazyOpen = player.getCapability(INSTRUMENT_OPEN);
        return lazyOpen.isPresent() ? ifExists.apply((InstrumentOpen)lazyOpen.resolve().get()) : elseVal;
    }
}

