/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.capability.instrumentOpen;

import com.cstav.genshinstrument.capability.instrumentOpen.InstrumentOpenProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.AutoRegisterCapability;
import net.minecraftforge.common.util.LazyOptional;

@AutoRegisterCapability
public class InstrumentOpen {
    public static final String OPEN_TAG = "instrumentOpen";
    public static final String IS_ITEM_TAG = "isItem";
    public static final String BLOCK_POS_TAG = "blockPos";
    public static final String HAND_TAG = "inOffhand";
    private boolean isOpen = false;
    private boolean isItem = false;
    private BlockPos blockPos;
    private InteractionHand hand;

    public static boolean isOpen(Player player) {
        LazyOptional oIsOpen = player.getCapability(InstrumentOpenProvider.INSTRUMENT_OPEN);
        return oIsOpen.isPresent() && ((InstrumentOpen)oIsOpen.resolve().get()).isOpen;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public boolean isItem() {
        return this.isItem;
    }

    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    public InteractionHand getHand() {
        return this.hand;
    }

    public void setOpen(InteractionHand hand) {
        this.isOpen = true;
        this.hand = hand;
        this.isItem = true;
    }

    public void setOpen(BlockPos blockPos) {
        this.isOpen = true;
        this.blockPos = blockPos;
        this.isItem = false;
    }

    public void setClosed() {
        this.isOpen = false;
    }

    public void setBlockPos(BlockPos blockPos) {
        this.blockPos = blockPos;
    }

    public void saveNBTData(CompoundTag nbt) {
        nbt.m_128379_(OPEN_TAG, this.isOpen);
        nbt.m_128379_(IS_ITEM_TAG, this.isItem);
        if (this.blockPos != null) {
            nbt.m_128365_(BLOCK_POS_TAG, (Tag)NbtUtils.m_129224_((BlockPos)this.blockPos));
        }
        if (this.hand != null) {
            nbt.m_128379_(HAND_TAG, this.hand == InteractionHand.OFF_HAND);
        }
    }

    public void loadNBTData(CompoundTag nbt) {
        this.isOpen = nbt.m_128471_(OPEN_TAG);
        this.isItem = nbt.m_128471_(IS_ITEM_TAG);
        if (nbt.m_128425_(BLOCK_POS_TAG, 10)) {
            this.blockPos = NbtUtils.m_129239_((CompoundTag)nbt.m_128469_(BLOCK_POS_TAG));
        }
        if (nbt.m_128425_(HAND_TAG, 1)) {
            this.hand = nbt.m_128471_(HAND_TAG) ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
        }
    }
}

