/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.texture.pbr;

import com.mojang.blaze3d.platform.GlStateManager;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.IOException;
import java.nio.file.Path;
import net.coderbot.iris.Iris;
import net.coderbot.iris.gl.state.StateUpdateNotifiers;
import net.coderbot.iris.mixin.GlStateManagerAccessor;
import net.coderbot.iris.rendertarget.NativeImageBackedSingleColorTexture;
import net.coderbot.iris.texture.TextureTracker;
import net.coderbot.iris.texture.pbr.PBRDumpable;
import net.coderbot.iris.texture.pbr.PBRTextureHolder;
import net.coderbot.iris.texture.pbr.PBRType;
import net.coderbot.iris.texture.pbr.loader.PBRTextureLoader;
import net.coderbot.iris.texture.pbr.loader.PBRTextureLoaderRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.Dumpable;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class PBRTextureManager {
    public static final PBRTextureManager INSTANCE = new PBRTextureManager();
    private static Runnable normalTextureChangeListener;
    private static Runnable specularTextureChangeListener;
    private final Int2ObjectMap<PBRTextureHolder> holders = new Int2ObjectOpenHashMap();
    private final PBRTextureConsumerImpl consumer = new PBRTextureConsumerImpl();
    private NativeImageBackedSingleColorTexture defaultNormalTexture;
    private NativeImageBackedSingleColorTexture defaultSpecularTexture;
    private final PBRTextureHolder defaultHolder = new PBRTextureHolder(){

        @Override
        @NotNull
        public AbstractTexture getNormalTexture() {
            return PBRTextureManager.this.defaultNormalTexture;
        }

        @Override
        @NotNull
        public AbstractTexture getSpecularTexture() {
            return PBRTextureManager.this.defaultSpecularTexture;
        }
    };

    private PBRTextureManager() {
    }

    public void init() {
        this.defaultNormalTexture = new NativeImageBackedSingleColorTexture(PBRType.NORMAL.getDefaultValue());
        this.defaultSpecularTexture = new NativeImageBackedSingleColorTexture(PBRType.SPECULAR.getDefaultValue());
    }

    public PBRTextureHolder getHolder(int id) {
        PBRTextureHolder holder = (PBRTextureHolder)this.holders.get(id);
        if (holder == null) {
            return this.defaultHolder;
        }
        return holder;
    }

    public PBRTextureHolder getOrLoadHolder(int id) {
        PBRTextureHolder holder = (PBRTextureHolder)this.holders.get(id);
        if (holder == null) {
            holder = this.loadHolder(id);
            this.holders.put(id, (Object)holder);
        }
        return holder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PBRTextureHolder loadHolder(int id) {
        Class<?> clazz;
        PBRTextureLoader<?> loader;
        AbstractTexture texture = TextureTracker.INSTANCE.getTexture(id);
        if (texture != null && (loader = PBRTextureLoaderRegistry.INSTANCE.getLoader(clazz = texture.getClass())) != null) {
            int previousTextureBinding = GlStateManagerAccessor.getTEXTURES()[GlStateManagerAccessor.getActiveTexture()].f_84801_;
            this.consumer.clear();
            try {
                loader.load(texture, Minecraft.m_91087_().m_91098_(), this.consumer);
                PBRTextureHolder pBRTextureHolder = this.consumer.toHolder();
                return pBRTextureHolder;
            }
            catch (Exception e) {
                Iris.logger.debug("Failed to load PBR textures for texture " + id, e);
            }
            finally {
                GlStateManager._bindTexture((int)previousTextureBinding);
            }
        }
        return this.defaultHolder;
    }

    public void onDeleteTexture(int id) {
        PBRTextureHolder holder = (PBRTextureHolder)this.holders.remove(id);
        if (holder != null) {
            this.closeHolder(holder);
        }
    }

    public void dumpTextures(Path path) {
        for (PBRTextureHolder holder : this.holders.values()) {
            if (holder == this.defaultHolder) continue;
            this.dumpHolder(holder, path);
        }
    }

    private void dumpHolder(PBRTextureHolder holder, Path path) {
        PBRDumpable dumpable;
        AbstractTexture normalTexture = holder.getNormalTexture();
        AbstractTexture specularTexture = holder.getSpecularTexture();
        if (normalTexture != this.defaultNormalTexture && normalTexture instanceof PBRDumpable) {
            dumpable = (PBRDumpable)normalTexture;
            PBRTextureManager.dumpTexture(dumpable, dumpable.getDefaultDumpLocation(), path);
        }
        if (specularTexture != this.defaultSpecularTexture && specularTexture instanceof PBRDumpable) {
            dumpable = (PBRDumpable)specularTexture;
            PBRTextureManager.dumpTexture(dumpable, dumpable.getDefaultDumpLocation(), path);
        }
    }

    private static void dumpTexture(Dumpable dumpable, ResourceLocation id, Path path) {
        try {
            dumpable.m_276079_(id, path);
        }
        catch (IOException e) {
            Iris.logger.error("Failed to dump texture {}", id, e);
        }
    }

    public void clear() {
        for (PBRTextureHolder holder : this.holders.values()) {
            if (holder == this.defaultHolder) continue;
            this.closeHolder(holder);
        }
        this.holders.clear();
    }

    public void close() {
        this.clear();
        this.defaultNormalTexture.close();
        this.defaultSpecularTexture.close();
    }

    private void closeHolder(PBRTextureHolder holder) {
        AbstractTexture normalTexture = holder.getNormalTexture();
        AbstractTexture specularTexture = holder.getSpecularTexture();
        if (normalTexture != this.defaultNormalTexture) {
            PBRTextureManager.closeTexture(normalTexture);
        }
        if (specularTexture != this.defaultSpecularTexture) {
            PBRTextureManager.closeTexture(specularTexture);
        }
    }

    private static void closeTexture(AbstractTexture texture) {
        try {
            texture.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        texture.m_117964_();
    }

    public static void notifyPBRTexturesChanged() {
        if (normalTextureChangeListener != null) {
            normalTextureChangeListener.run();
        }
        if (specularTextureChangeListener != null) {
            specularTextureChangeListener.run();
        }
    }

    static {
        StateUpdateNotifiers.normalTextureChangeNotifier = listener -> {
            normalTextureChangeListener = listener;
        };
        StateUpdateNotifiers.specularTextureChangeNotifier = listener -> {
            specularTextureChangeListener = listener;
        };
    }

    private class PBRTextureConsumerImpl
    implements PBRTextureLoader.PBRTextureConsumer {
        private AbstractTexture normalTexture;
        private AbstractTexture specularTexture;
        private boolean changed;

        private PBRTextureConsumerImpl() {
        }

        @Override
        public void acceptNormalTexture(@NotNull AbstractTexture texture) {
            this.normalTexture = texture;
            this.changed = true;
        }

        @Override
        public void acceptSpecularTexture(@NotNull AbstractTexture texture) {
            this.specularTexture = texture;
            this.changed = true;
        }

        public void clear() {
            this.normalTexture = PBRTextureManager.this.defaultNormalTexture;
            this.specularTexture = PBRTextureManager.this.defaultSpecularTexture;
            this.changed = false;
        }

        public PBRTextureHolder toHolder() {
            if (this.changed) {
                return new PBRTextureHolderImpl(this.normalTexture, this.specularTexture);
            }
            return PBRTextureManager.this.defaultHolder;
        }
    }

    private static class PBRTextureHolderImpl
    implements PBRTextureHolder {
        private final AbstractTexture normalTexture;
        private final AbstractTexture specularTexture;

        public PBRTextureHolderImpl(AbstractTexture normalTexture, AbstractTexture specularTexture) {
            this.normalTexture = normalTexture;
            this.specularTexture = specularTexture;
        }

        @Override
        @NotNull
        public AbstractTexture getNormalTexture() {
            return this.normalTexture;
        }

        @Override
        @NotNull
        public AbstractTexture getSpecularTexture() {
            return this.specularTexture;
        }
    }
}

