/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Either;
import io.github.mortuusars.exposure.ExposureClient;
import io.github.mortuusars.exposure.data.storage.ExposureSavedData;
import io.github.mortuusars.exposure.render.ExposureImage;
import io.github.mortuusars.exposure.render.ExposureTexture;
import io.github.mortuusars.exposure.render.modifiers.IPixelModifier;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class ExposureRenderer
implements AutoCloseable {
    private final Map<String, ExposureInstance> cache = new HashMap<String, ExposureInstance>();

    public int getSize() {
        return 256;
    }

    public void render(@NotNull Either<String, ResourceLocation> idOrTexture, IPixelModifier modifier, PoseStack poseStack, MultiBufferSource bufferSource) {
        this.render(idOrTexture, modifier, poseStack, bufferSource, 0.0f, 0.0f, this.getSize(), this.getSize());
    }

    public void render(@NotNull Either<String, ResourceLocation> idOrTexture, IPixelModifier modifier, PoseStack poseStack, MultiBufferSource bufferSource, float x, float y, float width, float height) {
        this.render(idOrTexture, modifier, poseStack, bufferSource, x, y, x + width, y + height, 0.0f, 0.0f, 1.0f, 1.0f, 0xF000F0, 255, 255, 255, 255);
    }

    public void render(@NotNull Either<String, ResourceLocation> idOrTexture, IPixelModifier modifier, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int r, int g, int b, int a) {
        this.render(idOrTexture, modifier, poseStack, bufferSource, 0.0f, 0.0f, this.getSize(), this.getSize(), packedLight, r, g, b, a);
    }

    public void render(@NotNull Either<String, ResourceLocation> idOrTexture, IPixelModifier modifier, PoseStack poseStack, MultiBufferSource bufferSource, float x, float y, float width, float height, int packedLight, int r, int g, int b, int a) {
        this.render(idOrTexture, modifier, poseStack, bufferSource, x, y, x + width, y + height, 0.0f, 0.0f, 1.0f, 1.0f, packedLight, r, g, b, a);
    }

    public void render(@NotNull Either<String, ResourceLocation> idOrTexture, IPixelModifier modifier, PoseStack poseStack, MultiBufferSource bufferSource, float minX, float minY, float maxX, float maxY, float minU, float minV, float maxU, float maxV, int packedLight, int r, int g, int b, int a) {
        @Nullable ExposureImage exposure = (ExposureImage)idOrTexture.map(id -> ExposureClient.getExposureStorage().getOrQuery((String)id).map(data -> new ExposureImage((String)id, (ExposureSavedData)((Object)((Object)data)))).orElse(null), texture -> {
            @Nullable ExposureTexture exposureTexture = ExposureTexture.getTexture(texture);
            if (exposureTexture != null) {
                return new ExposureImage(texture.toString(), exposureTexture);
            }
            return null;
        });
        if (exposure != null) {
            String id2 = (String)idOrTexture.map(expId -> expId, ResourceLocation::toString);
            this.getOrCreateExposureInstance(id2, exposure, modifier).draw(poseStack, bufferSource, minX, minY, maxX, maxY, minU, minV, maxU, maxV, packedLight, r, g, b, a);
        }
    }

    private ExposureInstance getOrCreateExposureInstance(String id, ExposureImage exposure, IPixelModifier modifier) {
        String instanceId = id + modifier.getIdSuffix();
        return this.cache.compute(instanceId, (expId, expData) -> {
            if (expData == null) {
                return new ExposureInstance((String)expId, exposure, modifier);
            }
            expData.replaceData(exposure);
            return expData;
        });
    }

    public void clearData() {
        for (ExposureInstance instance : this.cache.values()) {
            instance.close();
        }
        this.cache.clear();
    }

    public void clearDataSingle(@NotNull String exposureId, boolean allVariants) {
        Iterator<Map.Entry<String, ExposureInstance>> it = this.cache.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, ExposureInstance> entry = it.next();
            if (!(allVariants ? entry.getKey().startsWith(exposureId) : entry.getKey().equals(exposureId))) continue;
            entry.getValue().close();
            it.remove();
            if (allVariants) continue;
            break;
        }
    }

    @Override
    public void close() {
        this.clearData();
    }

    static class ExposureInstance
    implements AutoCloseable {
        private final RenderType renderType;
        private ExposureImage exposure;
        private DynamicTexture texture;
        private final IPixelModifier pixelModifier;
        private boolean requiresUpload = true;

        ExposureInstance(String id, ExposureImage exposure, IPixelModifier modifier) {
            this.exposure = exposure;
            this.texture = new DynamicTexture(exposure.getWidth(), exposure.getHeight(), true);
            this.pixelModifier = modifier;
            String textureId = ExposureInstance.createTextureId(id);
            ResourceLocation resourcelocation = Minecraft.m_91087_().m_91097_().m_118490_(textureId, this.texture);
            this.renderType = RenderType.m_110497_((ResourceLocation)resourcelocation);
        }

        private static String createTextureId(String exposureId) {
            Object id = "exposure/" + exposureId.toLowerCase();
            id = ((String)id).replace(':', '_');
            Pattern pattern = Pattern.compile("[^a-z0-9_.-]");
            Matcher matcher = pattern.matcher((CharSequence)id);
            StringBuilder sb = new StringBuilder();
            while (matcher.find()) {
                matcher.appendReplacement(sb, String.valueOf(matcher.group().hashCode()));
            }
            matcher.appendTail(sb);
            return sb.toString();
        }

        private void replaceData(ExposureImage exposure) {
            boolean hasChanged = !this.exposure.getName().equals(exposure.getName());
            this.exposure = exposure;
            if (hasChanged) {
                this.texture = new DynamicTexture(exposure.getWidth(), exposure.getHeight(), true);
            }
            this.requiresUpload |= hasChanged;
        }

        public void forceUpload() {
            this.requiresUpload = true;
        }

        private void updateTexture() {
            if (this.texture.m_117991_() == null) {
                return;
            }
            for (int y = 0; y < this.exposure.getHeight(); ++y) {
                for (int x = 0; x < this.exposure.getWidth(); ++x) {
                    int ABGR = this.exposure.getPixelABGR(x, y);
                    ABGR = this.pixelModifier.modifyPixel(ABGR);
                    this.texture.m_117991_().m_84988_(x, y, ABGR);
                }
            }
            this.texture.m_117985_();
        }

        void draw(PoseStack poseStack, MultiBufferSource bufferSource, float minX, float minY, float maxX, float maxY, float minU, float minV, float maxU, float maxV, int packedLight, int r, int g, int b, int a) {
            if (this.requiresUpload) {
                this.updateTexture();
                this.requiresUpload = false;
            }
            Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
            VertexConsumer vertexconsumer = bufferSource.m_6299_(this.renderType);
            vertexconsumer.m_252986_(matrix4f, minX, maxY, 0.0f).m_6122_(r, g, b, a).m_7421_(minU, maxV).m_85969_(packedLight).m_5752_();
            vertexconsumer.m_252986_(matrix4f, maxX, maxY, 0.0f).m_6122_(r, g, b, a).m_7421_(maxU, maxV).m_85969_(packedLight).m_5752_();
            vertexconsumer.m_252986_(matrix4f, maxX, minY, 0.0f).m_6122_(r, g, b, a).m_7421_(maxU, minV).m_85969_(packedLight).m_5752_();
            vertexconsumer.m_252986_(matrix4f, minX, minY, 0.0f).m_6122_(r, g, b, a).m_7421_(minU, minV).m_85969_(packedLight).m_5752_();
        }

        @Override
        public void close() {
            this.texture.close();
        }
    }
}

