/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.network.packet.server;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.util.Either;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.item.AlbumPage;
import io.github.mortuusars.exposure.menu.AlbumMenu;
import io.github.mortuusars.exposure.network.PacketDirection;
import io.github.mortuusars.exposure.network.packet.IPacket;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.Nullable;

public record AlbumSyncNoteC2SP(int pageIndex, String text) implements IPacket
{
    public static final ResourceLocation ID = Exposure.resource("album_update_note");

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    public static AlbumSyncNoteC2SP fromBuffer(FriendlyByteBuf buffer) {
        return new AlbumSyncNoteC2SP(buffer.readInt(), buffer.m_130277_());
    }

    @Override
    public FriendlyByteBuf toBuffer(FriendlyByteBuf buffer) {
        buffer.writeInt(this.pageIndex);
        buffer.m_130070_(this.text);
        return buffer;
    }

    @Override
    public boolean handle(PacketDirection direction, @Nullable Player player) {
        Preconditions.checkState((player != null ? 1 : 0) != 0, (Object)"Cannot handle packet: Player was null");
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (!(abstractContainerMenu instanceof AlbumMenu)) {
            throw new IllegalStateException("Player receiving this packet should have AlbumMenu open. Current menu: " + player.f_36096_);
        }
        AlbumMenu albumMenu = (AlbumMenu)abstractContainerMenu;
        AlbumPage page = albumMenu.getPages().get(this.pageIndex);
        page.setNote((Either<String, Component>)Either.left((Object)this.text));
        albumMenu.updateAlbumStack();
        return true;
    }
}

