/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.network.handler;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.ExposureClient;
import io.github.mortuusars.exposure.camera.capture.Capture;
import io.github.mortuusars.exposure.camera.capture.CaptureManager;
import io.github.mortuusars.exposure.camera.capture.CapturedFramesHistory;
import io.github.mortuusars.exposure.camera.capture.component.BaseComponent;
import io.github.mortuusars.exposure.camera.capture.component.ExposureExporterComponent;
import io.github.mortuusars.exposure.camera.capture.component.ExposureStorageSaveComponent;
import io.github.mortuusars.exposure.camera.capture.component.ICaptureComponent;
import io.github.mortuusars.exposure.camera.capture.converter.DitheringColorConverter;
import io.github.mortuusars.exposure.camera.capture.converter.SimpleColorConverter;
import io.github.mortuusars.exposure.data.ExposureSize;
import io.github.mortuusars.exposure.data.Lenses;
import io.github.mortuusars.exposure.gui.screen.NegativeExposureScreen;
import io.github.mortuusars.exposure.gui.screen.PhotographScreen;
import io.github.mortuusars.exposure.item.CameraItem;
import io.github.mortuusars.exposure.item.PhotographItem;
import io.github.mortuusars.exposure.network.packet.client.ApplyShaderS2CP;
import io.github.mortuusars.exposure.network.packet.client.ExposureChangedS2CP;
import io.github.mortuusars.exposure.network.packet.client.ShowExposureS2CP;
import io.github.mortuusars.exposure.network.packet.client.StartExposureS2CP;
import io.github.mortuusars.exposure.network.packet.client.SyncLensesS2CP;
import io.github.mortuusars.exposure.network.packet.client.WaitForExposureChangeS2CP;
import io.github.mortuusars.exposure.render.modifiers.ExposurePixelModifiers;
import io.github.mortuusars.exposure.util.ClientsideWorldNameGetter;
import io.github.mortuusars.exposure.util.ColorUtils;
import io.github.mortuusars.exposure.util.ItemAndStack;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.imageio.ImageIO;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringUtil;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class ClientPacketsHandler {
    public static void applyShader(ApplyShaderS2CP packet) {
        ClientPacketsHandler.executeOnMainThread(() -> {
            if (packet.shaderLocation().m_135815_().equals("none")) {
                Minecraft.m_91087_().f_91063_.m_109086_();
            } else {
                Minecraft.m_91087_().f_91063_.m_109128_(packet.shaderLocation());
            }
        });
    }

    public static void exposeScreenshot(int size) {
        Preconditions.checkState((size > 0 ? 1 : 0) != 0, (Object)(size + " size is invalid. Should be larger than 0."));
        if (size == Integer.MAX_VALUE) {
            size = Math.min(Minecraft.m_91087_().m_91268_().m_85441_(), Minecraft.m_91087_().m_91268_().m_85442_());
        }
        int finalSize = size;
        ClientPacketsHandler.executeOnMainThread(() -> {
            final String filename = Util.m_241986_();
            CompoundTag frameData = new CompoundTag();
            frameData.m_128359_("Id", filename);
            Capture capture = new Capture(filename, frameData).size(finalSize).cropFactor(1.0f).components(new BaseComponent(true), ((ExposureExporterComponent)new ExposureExporterComponent(filename).organizeByWorld((boolean)((Boolean)Config.Client.EXPOSURE_SAVING_LEVEL_SUBFOLDER.get()), ClientsideWorldNameGetter::getWorldName)).withModifier(ExposurePixelModifiers.EMPTY).withSize(ExposureSize.X1), new ICaptureComponent(){

                @Override
                public void end(Capture capture) {
                    LogUtils.getLogger().info("Saved exposure screenshot: " + filename);
                }
            }).converter(new DitheringColorConverter());
            CaptureManager.enqueue(capture);
        });
    }

    public static void loadExposure(String exposureId, String path, int size, boolean dither) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (StringUtil.m_14408_((String)exposureId)) {
            if (player == null) {
                throw new IllegalStateException("Cannot load exposure: path is null or empty and player is null.");
            }
            exposureId = player.m_7755_().getString() + player.m_9236_().m_46467_();
        }
        String finalExposureId = exposureId;
        new Thread(() -> {
            try {
                BufferedImage read = ImageIO.read(new File(path));
                NativeImage image = new NativeImage(read.getWidth(), read.getHeight(), false);
                for (int x = 0; x < read.getWidth(); ++x) {
                    for (int y = 0; y < read.getHeight(); ++y) {
                        image.m_84988_(x, y, ColorUtils.BGRtoRGB(read.getRGB(x, y)));
                    }
                }
                CompoundTag frameData = new CompoundTag();
                frameData.m_128359_("Id", finalExposureId);
                Capture capture = new Capture(finalExposureId, frameData).size(size).cropFactor(1.0f).components(new ExposureStorageSaveComponent(finalExposureId, true)).converter(dither ? new DitheringColorConverter() : new SimpleColorConverter());
                capture.processImage(image);
                LogUtils.getLogger().info("Loaded exposure from file '" + path + "' with Id: '" + finalExposureId + "'.");
                Objects.requireNonNull(Minecraft.m_91087_().f_91074_).m_5661_((Component)Component.m_237110_((String)"command.exposure.load_from_file.success", (Object[])new Object[]{finalExposureId}).m_130940_(ChatFormatting.GREEN), false);
            }
            catch (IOException e) {
                LogUtils.getLogger().error("Cannot load exposure:" + e);
                Objects.requireNonNull(Minecraft.m_91087_().f_91074_).m_5661_((Component)Component.m_237115_((String)"command.exposure.load_from_file.failure").m_130940_(ChatFormatting.RED), false);
            }
        }).start();
    }

    public static void startExposure(StartExposureS2CP packet) {
        Minecraft.m_91087_().execute(() -> {
            CameraItem cameraItem;
            @Nullable LocalPlayer player = Minecraft.m_91087_().f_91074_;
            Preconditions.checkState((player != null ? 1 : 0) != 0, (Object)"Player cannot be null.");
            ItemStack itemInHand = player.m_21120_(packet.activeHand());
            Item patt7640$temp = itemInHand.m_41720_();
            if (!(patt7640$temp instanceof CameraItem) || !(cameraItem = (CameraItem)patt7640$temp).isActive(itemInHand)) {
                throw new IllegalStateException("Player should have active Camera in hand. " + itemInHand);
            }
            cameraItem.exposeFrameClientside((Player)player, packet.activeHand(), packet.exposureId(), packet.flashHasFired(), packet.lightLevel());
        });
    }

    public static void showExposure(ShowExposureS2CP packet) {
        ClientPacketsHandler.executeOnMainThread(() -> {
            Screen screen;
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null) {
                LogUtils.getLogger().error("Cannot show exposures. Player is null.");
                return;
            }
            boolean negative = packet.negative();
            if (packet.latest()) {
                screen = ClientPacketsHandler.createLatestScreen((Player)player, negative);
            } else if (negative) {
                Either idOrTexture = packet.isTexture() ? Either.right((Object)new ResourceLocation(packet.idOrPath())) : Either.left((Object)packet.idOrPath());
                screen = new NegativeExposureScreen(List.of(idOrTexture));
            } else {
                ItemStack stack = new ItemStack((ItemLike)Exposure.Items.PHOTOGRAPH.get());
                CompoundTag tag = new CompoundTag();
                tag.m_128359_(packet.isTexture() ? "Texture" : "Id", packet.idOrPath());
                stack.m_41751_(tag);
                screen = new PhotographScreen(List.of(new ItemAndStack(stack)));
            }
            if (screen != null) {
                Minecraft.m_91087_().m_91152_(screen);
            }
        });
    }

    @Nullable
    private static Screen createLatestScreen(Player player, boolean negative) {
        List<CompoundTag> latestFrames = CapturedFramesHistory.get().stream().filter(frame -> !frame.m_128461_("Id").isEmpty()).toList();
        if (latestFrames.isEmpty()) {
            player.m_5661_((Component)Component.m_237115_((String)"command.exposure.show.latest.error.no_exposures"), false);
            return null;
        }
        if (negative) {
            ArrayList<Either<String, ResourceLocation>> exposures = new ArrayList<Either<String, ResourceLocation>>();
            for (CompoundTag frame2 : latestFrames) {
                String exposureId = frame2.m_128461_("Id");
                exposures.add((Either<String, ResourceLocation>)Either.left((Object)exposureId));
            }
            return new NegativeExposureScreen(exposures);
        }
        ArrayList<ItemAndStack<PhotographItem>> photographs = new ArrayList<ItemAndStack<PhotographItem>>();
        for (CompoundTag frame3 : latestFrames) {
            ItemStack stack = new ItemStack((ItemLike)Exposure.Items.PHOTOGRAPH.get());
            stack.m_41751_(frame3);
            photographs.add(new ItemAndStack(stack));
        }
        return new PhotographScreen(photographs);
    }

    public static void clearRenderingCache() {
        ClientPacketsHandler.executeOnMainThread(() -> ExposureClient.getExposureRenderer().clearData());
    }

    public static void syncLenses(SyncLensesS2CP packet) {
        ClientPacketsHandler.executeOnMainThread(() -> Lenses.reload(packet.lenses()));
    }

    public static void waitForExposureChange(WaitForExposureChangeS2CP packet) {
        ClientPacketsHandler.executeOnMainThread(() -> ExposureClient.getExposureStorage().putOnWaitingList(packet.exposureId()));
    }

    public static void onExposureChanged(ExposureChangedS2CP packet) {
        ClientPacketsHandler.executeOnMainThread(() -> {
            ExposureClient.getExposureStorage().remove(packet.exposureId());
            ExposureClient.getExposureRenderer().clearDataSingle(packet.exposureId(), true);
        });
    }

    private static void executeOnMainThread(Runnable runnable) {
        Minecraft.m_91087_().execute(runnable);
    }
}

