/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.network.forge;

import io.github.mortuusars.exposure.network.PacketDirection;
import io.github.mortuusars.exposure.network.packet.ExposureDataPartPacket;
import io.github.mortuusars.exposure.network.packet.IPacket;
import io.github.mortuusars.exposure.network.packet.client.ApplyShaderS2CP;
import io.github.mortuusars.exposure.network.packet.client.ClearRenderingCacheS2CP;
import io.github.mortuusars.exposure.network.packet.client.ExposeCommandS2CP;
import io.github.mortuusars.exposure.network.packet.client.ExposureChangedS2CP;
import io.github.mortuusars.exposure.network.packet.client.LoadExposureCommandS2CP;
import io.github.mortuusars.exposure.network.packet.client.PlayOnePerPlayerSoundS2CP;
import io.github.mortuusars.exposure.network.packet.client.ShowExposureS2CP;
import io.github.mortuusars.exposure.network.packet.client.StartExposureS2CP;
import io.github.mortuusars.exposure.network.packet.client.StopOnePerPlayerSoundS2CP;
import io.github.mortuusars.exposure.network.packet.client.SyncLensesS2CP;
import io.github.mortuusars.exposure.network.packet.client.WaitForExposureChangeS2CP;
import io.github.mortuusars.exposure.network.packet.server.AlbumSignC2SP;
import io.github.mortuusars.exposure.network.packet.server.AlbumSyncNoteC2SP;
import io.github.mortuusars.exposure.network.packet.server.CameraInHandAddFrameC2SP;
import io.github.mortuusars.exposure.network.packet.server.CameraSetCompositionGuideC2SP;
import io.github.mortuusars.exposure.network.packet.server.CameraSetFlashModeC2SP;
import io.github.mortuusars.exposure.network.packet.server.CameraSetSelfieModeC2SP;
import io.github.mortuusars.exposure.network.packet.server.CameraSetShutterSpeedC2SP;
import io.github.mortuusars.exposure.network.packet.server.CameraSetZoomC2SP;
import io.github.mortuusars.exposure.network.packet.server.DeactivateCamerasInHandC2SP;
import io.github.mortuusars.exposure.network.packet.server.QueryExposureDataC2SP;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class PacketsImpl {
    private static final String PROTOCOL_VERSION = "1";
    private static int id = 0;
    private static final SimpleChannel CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("exposure:packets"), () -> "1", "1"::equals, "1"::equals);

    public static void register() {
        CHANNEL.messageBuilder(ExposureDataPartPacket.class, id++).encoder(ExposureDataPartPacket::toBuffer).decoder(ExposureDataPartPacket::fromBuffer).consumerMainThread(PacketsImpl::handlePacket).add();
        CHANNEL.messageBuilder(DeactivateCamerasInHandC2SP.class, id++, NetworkDirection.PLAY_TO_SERVER).encoder(DeactivateCamerasInHandC2SP::toBuffer).decoder(DeactivateCamerasInHandC2SP::fromBuffer).consumerMainThread(PacketsImpl::handlePacket).add();
        CHANNEL.messageBuilder(CameraSetZoomC2SP.class, id++, NetworkDirection.PLAY_TO_SERVER).encoder(CameraSetZoomC2SP::toBuffer).decoder(CameraSetZoomC2SP::fromBuffer).consumerMainThread(PacketsImpl::handlePacket).add();
        CHANNEL.messageBuilder(CameraSetCompositionGuideC2SP.class, id++, NetworkDirection.PLAY_TO_SERVER).encoder(CameraSetCompositionGuideC2SP::toBuffer).decoder(CameraSetCompositionGuideC2SP::fromBuffer).consumerMainThread(PacketsImpl::handlePacket).add();
        CHANNEL.messageBuilder(CameraSetFlashModeC2SP.class, id++, NetworkDirection.PLAY_TO_SERVER).encoder(CameraSetFlashModeC2SP::toBuffer).decoder(CameraSetFlashModeC2SP::fromBuffer).consumerMainThread(PacketsImpl::handlePacket).add();
        CHANNEL.messageBuilder(CameraSetShutterSpeedC2SP.class, id++, NetworkDirection.PLAY_TO_SERVER).encoder(CameraSetShutterSpeedC2SP::toBuffer).decoder(CameraSetShutterSpeedC2SP::fromBuffer).consumerMainThread(PacketsImpl::handlePacket).add();
        CHANNEL.messageBuilder(CameraInHandAddFrameC2SP.class, id++, NetworkDirection.PLAY_TO_SERVER).encoder(CameraInHandAddFrameC2SP::toBuffer).decoder(CameraInHandAddFrameC2SP::fromBuffer).consumerMainThread(PacketsImpl::handlePacket).add();
        CHANNEL.messageBuilder(CameraSetSelfieModeC2SP.class, id++, NetworkDirection.PLAY_TO_SERVER).encoder(CameraSetSelfieModeC2SP::toBuffer).decoder(CameraSetSelfieModeC2SP::fromBuffer).consumerMainThread(PacketsImpl::handlePacket).add();
        CHANNEL.messageBuilder(QueryExposureDataC2SP.class, id++, NetworkDirection.PLAY_TO_SERVER).encoder(QueryExposureDataC2SP::toBuffer).decoder(QueryExposureDataC2SP::fromBuffer).consumerMainThread(PacketsImpl::handlePacket).add();
        CHANNEL.messageBuilder(AlbumSyncNoteC2SP.class, id++, NetworkDirection.PLAY_TO_SERVER).encoder(AlbumSyncNoteC2SP::toBuffer).decoder(AlbumSyncNoteC2SP::fromBuffer).consumerMainThread(PacketsImpl::handlePacket).add();
        CHANNEL.messageBuilder(AlbumSignC2SP.class, id++, NetworkDirection.PLAY_TO_SERVER).encoder(AlbumSignC2SP::toBuffer).decoder(AlbumSignC2SP::fromBuffer).consumerMainThread(PacketsImpl::handlePacket).add();
        CHANNEL.messageBuilder(ApplyShaderS2CP.class, id++, NetworkDirection.PLAY_TO_CLIENT).encoder(ApplyShaderS2CP::toBuffer).decoder(ApplyShaderS2CP::fromBuffer).consumerMainThread(PacketsImpl::handlePacket).add();
        CHANNEL.messageBuilder(StartExposureS2CP.class, id++, NetworkDirection.PLAY_TO_CLIENT).encoder(StartExposureS2CP::toBuffer).decoder(StartExposureS2CP::fromBuffer).consumerMainThread(PacketsImpl::handlePacket).add();
        CHANNEL.messageBuilder(LoadExposureCommandS2CP.class, id++, NetworkDirection.PLAY_TO_CLIENT).encoder(LoadExposureCommandS2CP::toBuffer).decoder(LoadExposureCommandS2CP::fromBuffer).consumerMainThread(PacketsImpl::handlePacket).add();
        CHANNEL.messageBuilder(ShowExposureS2CP.class, id++, NetworkDirection.PLAY_TO_CLIENT).encoder(ShowExposureS2CP::toBuffer).decoder(ShowExposureS2CP::fromBuffer).consumerMainThread(PacketsImpl::handlePacket).add();
        CHANNEL.messageBuilder(ExposeCommandS2CP.class, id++, NetworkDirection.PLAY_TO_CLIENT).encoder(ExposeCommandS2CP::toBuffer).decoder(ExposeCommandS2CP::fromBuffer).consumerMainThread(PacketsImpl::handlePacket).add();
        CHANNEL.messageBuilder(PlayOnePerPlayerSoundS2CP.class, id++, NetworkDirection.PLAY_TO_CLIENT).encoder(PlayOnePerPlayerSoundS2CP::toBuffer).decoder(PlayOnePerPlayerSoundS2CP::fromBuffer).consumerMainThread(PacketsImpl::handlePacket).add();
        CHANNEL.messageBuilder(StopOnePerPlayerSoundS2CP.class, id++, NetworkDirection.PLAY_TO_CLIENT).encoder(StopOnePerPlayerSoundS2CP::toBuffer).decoder(StopOnePerPlayerSoundS2CP::fromBuffer).consumerMainThread(PacketsImpl::handlePacket).add();
        CHANNEL.messageBuilder(ClearRenderingCacheS2CP.class, id++, NetworkDirection.PLAY_TO_CLIENT).encoder(IPacket::toBuffer).decoder(ClearRenderingCacheS2CP::fromBuffer).consumerMainThread(PacketsImpl::handlePacket).add();
        CHANNEL.messageBuilder(SyncLensesS2CP.class, id++, NetworkDirection.PLAY_TO_CLIENT).encoder(SyncLensesS2CP::toBuffer).decoder(SyncLensesS2CP::fromBuffer).consumerMainThread(PacketsImpl::handlePacket).add();
        CHANNEL.messageBuilder(ExposureChangedS2CP.class, id++, NetworkDirection.PLAY_TO_CLIENT).encoder(ExposureChangedS2CP::toBuffer).decoder(ExposureChangedS2CP::fromBuffer).consumerMainThread(PacketsImpl::handlePacket).add();
        CHANNEL.messageBuilder(WaitForExposureChangeS2CP.class, id++, NetworkDirection.PLAY_TO_CLIENT).encoder(WaitForExposureChangeS2CP::toBuffer).decoder(WaitForExposureChangeS2CP::fromBuffer).consumerMainThread(PacketsImpl::handlePacket).add();
    }

    public static void sendToServer(IPacket packet) {
        CHANNEL.sendToServer((Object)packet);
    }

    public static void sendToClient(IPacket packet, ServerPlayer player) {
        CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)packet);
    }

    public static void sendToAllClients(IPacket packet) {
        CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)packet);
    }

    private static <T extends IPacket> void handlePacket(T packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        packet.handle(PacketsImpl.direction(context.getDirection()), (Player)context.getSender());
    }

    private static PacketDirection direction(NetworkDirection direction) {
        if (direction == NetworkDirection.PLAY_TO_SERVER) {
            return PacketDirection.TO_SERVER;
        }
        if (direction == NetworkDirection.PLAY_TO_CLIENT) {
            return PacketDirection.TO_CLIENT;
        }
        throw new IllegalStateException("Can only convert direction for Client/Server, not others.");
    }
}

