/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.item;

import com.google.common.base.Preconditions;
import com.mojang.logging.LogUtils;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.ExposureServer;
import io.github.mortuusars.exposure.camera.capture.processing.FloydDither;
import io.github.mortuusars.exposure.camera.infrastructure.FilmType;
import io.github.mortuusars.exposure.data.storage.ExposureSavedData;
import io.github.mortuusars.exposure.network.Packets;
import io.github.mortuusars.exposure.network.packet.client.WaitForExposureChangeS2CP;
import io.github.mortuusars.exposure.util.ColorChannel;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.MapColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChromaticSheetItem
extends Item {
    public static final String EXPOSURES_TAG = "Exposures";

    public ChromaticSheetItem(Item.Properties properties) {
        super(properties);
    }

    public List<CompoundTag> getExposures(ItemStack stack) {
        if (stack.m_41783_() == null || !stack.m_41783_().m_128425_(EXPOSURES_TAG, 9)) {
            return Collections.emptyList();
        }
        ListTag channelsList = stack.m_41783_().m_128437_(EXPOSURES_TAG, 10);
        return channelsList.stream().map(t -> (CompoundTag)t).collect(Collectors.toList());
    }

    public void addExposure(ItemStack stack, CompoundTag frame) {
        ListTag channelsList = this.getOrCreateExposuresTag(stack);
        channelsList.add((Object)frame);
        stack.m_41784_().m_128365_(EXPOSURES_TAG, (Tag)channelsList);
    }

    private ListTag getOrCreateExposuresTag(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        ListTag list = tag.m_128437_(EXPOSURES_TAG, 10);
        tag.m_128365_(EXPOSURES_TAG, (Tag)list);
        return list;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        List<CompoundTag> exposures = this.getExposures(stack);
        if (!exposures.isEmpty()) {
            MutableComponent component = Component.m_237115_((String)"gui.exposure.channel.red").m_130948_(Style.f_131099_.m_178520_(ColorChannel.RED.getRepresentationColor()));
            if (exposures.size() >= 2) {
                component.m_7220_((Component)Component.m_237115_((String)"gui.exposure.channel.separator").m_130940_(ChatFormatting.GRAY));
                component.m_7220_((Component)Component.m_237115_((String)"gui.exposure.channel.green").m_130948_(Style.f_131099_.m_178520_(ColorChannel.GREEN.getRepresentationColor())));
            }
            if (exposures.size() >= 3) {
                component.m_7220_((Component)Component.m_237115_((String)"gui.exposure.channel.separator").m_130940_(ChatFormatting.GRAY));
                component.m_7220_((Component)Component.m_237115_((String)"gui.exposure.channel.blue").m_130948_(Style.f_131099_.m_178520_(ColorChannel.BLUE.getRepresentationColor())));
            }
            tooltipComponents.add((Component)component);
            if (exposures.size() >= 3) {
                component.m_7220_((Component)Component.m_237115_((String)"item.exposure.chromatic_sheet.use_tooltip").m_130940_(ChatFormatting.GRAY));
            }
        }
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        ItemStack stack = player.m_21120_(usedHand);
        if (!level.f_46443_ && this.getExposures(stack).size() >= 3) {
            ItemStack result = this.finalize(level, stack);
            player.m_21008_(usedHand, result);
            return InteractionResultHolder.m_19090_((Object)result);
        }
        return super.m_7203_(level, player, usedHand);
    }

    public ItemStack finalize(@NotNull Level level, ItemStack stack) {
        Preconditions.checkState((!level.f_46443_ ? 1 : 0) != 0, (Object)"Can only finalize server-side.");
        List<CompoundTag> exposures = this.getExposures(stack);
        Preconditions.checkState((exposures.size() >= 3 ? 1 : 0) != 0, (Object)("Finalizing Chromatic Fragment requires 3 exposures. " + stack));
        CompoundTag redTag = exposures.get(0);
        String redId = redTag.m_128461_("Id");
        Optional<ExposureSavedData> redOpt = ExposureServer.getExposureStorage().getOrQuery(redId);
        if (redOpt.isEmpty()) {
            LogUtils.getLogger().error("Cannot create Chromatic Photograph: Red channel exposure '" + redId + "' is not found.");
            return stack;
        }
        CompoundTag greenTag = exposures.get(1);
        String greenId = greenTag.m_128461_("Id");
        Optional<ExposureSavedData> greenOpt = ExposureServer.getExposureStorage().getOrQuery(greenId);
        if (greenOpt.isEmpty()) {
            LogUtils.getLogger().error("Cannot create Chromatic Photograph: Green channel exposure '" + greenId + "' is not found.");
            return stack;
        }
        CompoundTag blueTag = exposures.get(2);
        String blueId = blueTag.m_128461_("Id");
        Optional<ExposureSavedData> blueOpt = ExposureServer.getExposureStorage().getOrQuery(blueId);
        if (blueOpt.isEmpty()) {
            LogUtils.getLogger().error("Cannot create Chromatic Photograph: Blue channel exposure '" + blueId + "' is not found.");
            return stack;
        }
        int underscoreIndex = redId.lastIndexOf("_");
        String name = underscoreIndex != -1 ? redId.substring(0, underscoreIndex) : Integer.toString(redId.hashCode());
        String id = String.format("%s_chromatic_%s", name, level.m_46467_());
        ItemStack photograph = new ItemStack((ItemLike)Exposure.Items.PHOTOGRAPH.get());
        CompoundTag tag = redTag.m_6426_();
        tag = tag.m_128391_(greenTag);
        tag = tag.m_128391_(blueTag);
        tag.m_128473_("ChromaticChannel");
        tag.m_128359_("Id", id);
        tag.m_128379_("Chromatic", true);
        tag.m_128359_("RedChannel", redId);
        tag.m_128359_("GreenChannel", greenId);
        tag.m_128359_("BlueChannel", blueId);
        tag.m_128359_("Type", FilmType.COLOR.m_7912_());
        photograph.m_41751_(tag);
        Packets.sendToAllClients(new WaitForExposureChangeS2CP(id));
        new Thread(() -> {
            try {
                this.processAndSaveTrichrome((ExposureSavedData)((Object)((Object)redOpt.get())), (ExposureSavedData)((Object)((Object)greenOpt.get())), (ExposureSavedData)((Object)((Object)blueOpt.get())), id);
            }
            catch (Exception e) {
                LogUtils.getLogger().error("Cannot process and save Chromatic Photograph: " + e);
            }
        }).start();
        return photograph;
    }

    protected void processAndSaveTrichrome(ExposureSavedData red, ExposureSavedData green, ExposureSavedData blue, String id) {
        int width = Math.min(red.getWidth(), Math.min(green.getWidth(), blue.getWidth()));
        int height = Math.min(red.getHeight(), Math.min(green.getHeight(), blue.getHeight()));
        if (width <= 0 || height <= 0) {
            LogUtils.getLogger().error("Cannot create Chromatic Photograph: Width and Height should be larger than 0. Width '{}', Height: '{}'.", (Object)width, (Object)height);
            return;
        }
        BufferedImage image = new BufferedImage(width, height, 1);
        for (int x = 0; x < image.getWidth(); ++x) {
            for (int y = 0; y < image.getHeight(); ++y) {
                int r = MapColor.m_284315_((int)red.getPixel(x, y)) >> 16 & 0xFF;
                int g = MapColor.m_284315_((int)green.getPixel(x, y)) >> 8 & 0xFF;
                int b = MapColor.m_284315_((int)blue.getPixel(x, y)) & 0xFF;
                int rgb = 0xFF000000 | r << 16 | g << 8 | b;
                image.setRGB(x, y, rgb);
            }
        }
        byte[] mapColorPixels = FloydDither.ditherWithMapColors(image);
        CompoundTag properties = new CompoundTag();
        properties.m_128359_("Type", FilmType.COLOR.m_7912_());
        long unixTime = System.currentTimeMillis() / 1000L;
        properties.m_128356_("Timestamp", unixTime);
        ExposureSavedData resultData = new ExposureSavedData(image.getWidth(), image.getHeight(), mapColorPixels, properties);
        ExposureServer.getExposureStorage().put(id, resultData);
        ExposureServer.getExposureStorage().sendExposureChanged(id);
    }
}

