/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.gui.screen.element;

import io.github.mortuusars.exposure.gui.screen.element.textbox.HorizontalAlignment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextBlock
extends AbstractWidget {
    public int fontColor = -16777216;
    public boolean drawShadow = false;
    public HorizontalAlignment alignment = HorizontalAlignment.LEFT;
    private final Font font;
    private final Function<Style, Boolean> componentClickedHandler;
    private List<FormattedCharSequence> renderedLines;
    private List<FormattedCharSequence> tooltipLines;

    public TextBlock(Font font, int x, int y, int width, int height, Component message, Function<Style, Boolean> componentClickedHandler) {
        super(x, y, width, height, message);
        this.font = font;
        this.componentClickedHandler = componentClickedHandler;
        this.makeLines();
    }

    public void m_93666_(Component message) {
        super.m_93666_(message);
        this.makeLines();
    }

    protected void makeLines() {
        Component text = this.m_6035_();
        List lines = this.font.m_92923_((FormattedText)text, this.m_5711_());
        int n = lines.size();
        Objects.requireNonNull(this.font);
        int availableLines = Math.min(n, this.f_93619_ / 9);
        ArrayList<FormattedCharSequence> visibleLines = new ArrayList<FormattedCharSequence>();
        for (int i = 0; i < availableLines; ++i) {
            FormattedCharSequence line = (FormattedCharSequence)lines.get(i);
            if (i == availableLines - 1 && availableLines < lines.size()) {
                line = FormattedCharSequence.m_13696_((FormattedCharSequence)line, (FormattedCharSequence)Component.m_237113_((String)"...").m_130948_(text.m_7383_()).m_7532_());
            }
            visibleLines.add(line);
        }
        List hiddenLines = Collections.emptyList();
        if (availableLines < lines.size()) {
            hiddenLines = new ArrayList(lines.stream().skip(availableLines).toList());
            hiddenLines.set(0, FormattedCharSequence.m_13696_((FormattedCharSequence)FormattedCharSequence.m_13714_((String)"...", (Style)text.m_7383_()), (FormattedCharSequence)((FormattedCharSequence)hiddenLines.get(0))));
        }
        this.renderedLines = visibleLines;
        this.tooltipLines = hiddenLines;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        Style style = this.getClickedComponentStyleAt(mouseX, mouseY);
        return button == 0 && style != null && this.componentClickedHandler.apply(style) != false;
    }

    protected void m_168797_(NarrationElementOutput narrationElementOutput) {
        narrationElementOutput.m_169146_(NarratedElementType.TITLE, (Component)this.m_5646_());
    }

    @NotNull
    protected MutableComponent m_5646_() {
        return this.m_6035_().m_6881_();
    }

    protected void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        Style style;
        for (int i = 0; i < this.renderedLines.size(); ++i) {
            FormattedCharSequence line = this.renderedLines.get(i);
            int x = this.m_252754_() + this.alignment.align(this.m_5711_(), this.font.m_92724_(line));
            int n = this.m_252907_();
            Objects.requireNonNull(this.font);
            guiGraphics.m_280649_(this.font, line, x, n + 9 * i, this.fontColor, this.drawShadow);
        }
        if (this.m_274382_() && (style = this.getClickedComponentStyleAt(mouseX, mouseY)) != null) {
            guiGraphics.m_280304_(this.font, style, mouseX, mouseY);
        }
        if (!this.tooltipLines.isEmpty() && this.m_5953_(mouseX, mouseY)) {
            guiGraphics.m_280547_(this.font, this.tooltipLines, DefaultTooltipPositioner.f_262752_, mouseX, mouseY);
        }
    }

    @Nullable
    public Style getClickedComponentStyleAt(double mouseX, double mouseY) {
        if (this.renderedLines.isEmpty()) {
            return null;
        }
        int x = Mth.m_14107_((double)(mouseX - (double)this.m_252754_()));
        int y = Mth.m_14107_((double)(mouseY - (double)this.m_252907_()));
        if (x < 0 || y < 0 || x > this.m_5711_() || y > this.m_93694_()) {
            return null;
        }
        Objects.requireNonNull(this.font);
        int hoveredLine = y / 9;
        if (hoveredLine >= this.renderedLines.size()) {
            return null;
        }
        FormattedCharSequence line = this.renderedLines.get(hoveredLine);
        int lineStart = this.alignment.align(this.m_5711_(), this.font.m_92724_(line));
        if (x < lineStart) {
            return null;
        }
        return this.font.m_92865_().m_92338_(line, x - lineStart);
    }
}

