/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.gui.screen.camera.button;

import com.google.common.base.Preconditions;
import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.camera.infrastructure.ShutterSpeed;
import io.github.mortuusars.exposure.camera.infrastructure.SynchronizedCameraInHandActions;
import io.github.mortuusars.exposure.gui.screen.camera.button.CycleButton;
import io.github.mortuusars.exposure.util.CameraInHand;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class ShutterSpeedButton
extends CycleButton {
    private final List<ShutterSpeed> shutterSpeeds;
    private final int secondaryFontColor;
    private final int mainFontColor;

    public ShutterSpeedButton(Screen screen, int x, int y, int width, int height, int u, int v, ResourceLocation texture) {
        super(screen, x, y, width, height, u, v, height, texture);
        CameraInHand camera = CameraInHand.getActive((Player)Minecraft.m_91087_().f_91074_);
        Preconditions.checkState((!camera.isEmpty() ? 1 : 0) != 0, (Object)"Player must hold an active camera at this point.");
        ArrayList<ShutterSpeed> speeds = new ArrayList<ShutterSpeed>(camera.getItem().getAllShutterSpeeds(camera.getStack()));
        Collections.reverse(speeds);
        this.shutterSpeeds = speeds;
        ShutterSpeed shutterSpeed = camera.getItem().getShutterSpeed(camera.getStack());
        if (!this.shutterSpeeds.contains(shutterSpeed)) {
            throw new IllegalStateException("Camera {" + camera.getStack() + "} has invalid shutter speed.");
        }
        int currentShutterSpeedIndex = 0;
        for (int i = 0; i < this.shutterSpeeds.size(); ++i) {
            if (!shutterSpeed.equals(this.shutterSpeeds.get(i))) continue;
            currentShutterSpeedIndex = i;
        }
        this.setupButtonElements(this.shutterSpeeds.size(), currentShutterSpeedIndex);
        this.secondaryFontColor = Config.Client.getSecondaryFontColor();
        this.mainFontColor = Config.Client.getMainFontColor();
    }

    public void m_7435_(SoundManager handler) {
        handler.m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)Exposure.SoundEvents.CAMERA_DIAL_CLICK.get(), (float)(Objects.requireNonNull(Minecraft.m_91087_().f_91073_).f_46441_.m_188501_() * 0.05f + 0.9f + (float)this.currentIndex * 0.01f), (float)0.7f));
    }

    @Override
    public void m_87963_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.m_87963_(guiGraphics, mouseX, mouseY, partialTick);
        ShutterSpeed shutterSpeed = this.shutterSpeeds.get(this.currentIndex);
        Object text = shutterSpeed.toString();
        if (shutterSpeed.equals(ShutterSpeed.DEFAULT)) {
            text = (String)text + "\u2022";
        }
        Font font = Minecraft.m_91087_().f_91062_;
        int textWidth = font.m_92895_((String)text);
        int xPos = 35 - textWidth / 2;
        guiGraphics.m_280056_(font, (String)text, this.m_252754_() + xPos, this.m_252907_() + 4, this.secondaryFontColor, false);
        guiGraphics.m_280056_(font, (String)text, this.m_252754_() + xPos, this.m_252907_() + 3, this.mainFontColor, false);
    }

    @Override
    public void renderToolTip(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.m_280557_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237115_((String)"gui.exposure.viewfinder.shutter_speed.tooltip"), mouseX, mouseY);
    }

    @Override
    protected void onCycle() {
        CameraInHand camera = CameraInHand.getActive((Player)Minecraft.m_91087_().f_91074_);
        if (!camera.isEmpty() && camera.getItem().getShutterSpeed(camera.getStack()) != this.shutterSpeeds.get(this.currentIndex)) {
            SynchronizedCameraInHandActions.setShutterSpeed(this.shutterSpeeds.get(this.currentIndex));
        }
    }
}

