/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.gui;

import io.github.mortuusars.exposure.gui.screen.PhotographScreen;
import io.github.mortuusars.exposure.gui.screen.camera.ViewfinderControlsScreen;
import io.github.mortuusars.exposure.item.PhotographItem;
import io.github.mortuusars.exposure.recipe.FilmDevelopingRecipe;
import io.github.mortuusars.exposure.recipe.PhotographCopyingRecipe;
import io.github.mortuusars.exposure.util.ItemAndStack;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClientGUI {
    public static void openPhotographScreen(List<ItemAndStack<PhotographItem>> photographs) {
        Minecraft.m_91087_().m_91152_((Screen)new PhotographScreen(photographs));
    }

    public static void openViewfinderControlsScreen() {
        Minecraft.m_91087_().m_91152_((Screen)new ViewfinderControlsScreen());
    }

    public static void addFilmRollDevelopingTooltip(ItemStack filmStack, @Nullable Level level, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag isAdvanced) {
        ClientGUI.addRecipeTooltip(filmStack, level, tooltipComponents, isAdvanced, r -> {
            FilmDevelopingRecipe filmDevelopingRecipe;
            return r instanceof FilmDevelopingRecipe && (filmDevelopingRecipe = (FilmDevelopingRecipe)((Object)r)).getTransferIngredient().test(filmStack);
        }, "item.exposure.film_roll.tooltip.details.develop");
    }

    public static void addPhotographCopyingTooltip(ItemStack photographStack, @Nullable Level level, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag isAdvanced) {
        ClientGUI.addRecipeTooltip(photographStack, level, tooltipComponents, isAdvanced, r -> {
            PhotographCopyingRecipe photographCopyingRecipe;
            return r instanceof PhotographCopyingRecipe && (photographCopyingRecipe = (PhotographCopyingRecipe)((Object)r)).getTransferIngredient().test(photographStack);
        }, "item.exposure.photograph.tooltip.details.copy");
    }

    private static void addRecipeTooltip(ItemStack stack, @Nullable Level level, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag isAdvanced, Predicate<CraftingRecipe> recipeFilter, String detailsKey) {
        if (level == null) {
            return;
        }
        tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.exposure.hold_for_details"));
        if (!Screen.m_96638_()) {
            return;
        }
        Optional<NonNullList> recipeIngredients = level.m_7465_().m_44013_(RecipeType.f_44107_).stream().filter(recipeFilter).findFirst().map(Recipe::m_7527_);
        if (recipeIngredients.isEmpty() || recipeIngredients.get().isEmpty()) {
            return;
        }
        NonNullList ingredients = recipeIngredients.get();
        tooltipComponents.add((Component)Component.m_237119_());
        Style orange = Style.f_131099_.m_178520_(13079883);
        Style yellow = Style.f_131099_.m_178520_(15653496);
        tooltipComponents.add((Component)Component.m_237115_((String)detailsKey).m_130948_(orange));
        for (int i = 0; i < ingredients.size(); ++i) {
            ItemStack[] stacks = ((Ingredient)ingredients.get(i)).m_43908_();
            if (stacks.length == 0) {
                tooltipComponents.add((Component)Component.m_237113_((String)"  ").m_7220_((Component)Component.m_237113_((String)"?").m_130948_(yellow)));
                continue;
            }
            if (stacks.length == 1) {
                tooltipComponents.add((Component)Component.m_237113_((String)"  ").m_7220_((Component)stacks[0].m_41786_().m_6881_().m_130948_(yellow)));
                continue;
            }
            int val = (int)Math.ceil((float)(level.m_46467_() + (long)(10 * i)) % (20.0f * (float)stacks.length) / 20.0f);
            int index = Mth.m_14045_((int)(val - 1), (int)0, (int)(stacks.length - 1));
            tooltipComponents.add((Component)Component.m_237113_((String)"  ").m_7220_((Component)stacks[index].m_41786_().m_6881_().m_130948_(yellow)));
        }
    }
}

