/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.forge.event;

import com.mojang.brigadier.CommandDispatcher;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.command.ExposureCommand;
import io.github.mortuusars.exposure.command.ShaderCommand;
import io.github.mortuusars.exposure.command.TestCommand;
import io.github.mortuusars.exposure.data.Lenses;
import io.github.mortuusars.exposure.data.LensesDataLoader;
import io.github.mortuusars.exposure.network.forge.PacketsImpl;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;

public class CommonEvents {

    public static class ForgeBus {
        @SubscribeEvent
        public static void serverStarting(ServerStartingEvent event) {
            Exposure.initServer(event.getServer());
        }

        @SubscribeEvent
        public static void addReloadListeners(AddReloadListenerEvent event) {
            event.addListener((PreparableReloadListener)new LensesDataLoader());
        }

        @SubscribeEvent
        public static void onDatapackSync(OnDatapackSyncEvent event) {
            Lenses.onDatapackSync(event.getPlayerList(), event.getPlayer());
        }

        @SubscribeEvent
        public static void registerCommands(RegisterCommandsEvent event) {
            ExposureCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
            ShaderCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
            TestCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        }
    }

    public static class ModBus {
        @SubscribeEvent
        public static void commonSetup(FMLCommonSetupEvent event) {
            event.enqueueWork(() -> {
                PacketsImpl.register();
                Exposure.Advancements.register();
                Exposure.Stats.register();
            });
        }

        @SubscribeEvent
        public static void onCreativeTabsBuild(BuildCreativeModeTabContentsEvent event) {
            if (event.getTabKey() == CreativeModeTabs.f_256869_) {
                event.m_246326_((ItemLike)Exposure.Items.CAMERA.get());
                event.m_246326_((ItemLike)Exposure.Items.BLACK_AND_WHITE_FILM.get());
                event.m_246326_((ItemLike)Exposure.Items.COLOR_FILM.get());
                event.m_246326_((ItemLike)Exposure.Items.DEVELOPED_BLACK_AND_WHITE_FILM.get());
                event.m_246326_((ItemLike)Exposure.Items.DEVELOPED_COLOR_FILM.get());
                event.m_246326_((ItemLike)Exposure.Items.PHOTOGRAPH.get());
                event.m_246326_((ItemLike)Exposure.Items.AGED_PHOTOGRAPH.get());
                event.m_246326_((ItemLike)Exposure.Items.STACKED_PHOTOGRAPHS.get());
                event.m_246326_((ItemLike)Exposure.Items.ALBUM.get());
            }
            if (event.getTabKey() == CreativeModeTabs.f_256791_) {
                event.m_246326_((ItemLike)Exposure.Items.LIGHTROOM.get());
            }
        }
    }
}

