/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.data.transfer;

import io.github.mortuusars.exposure.data.storage.ExposureSavedData;
import io.github.mortuusars.exposure.data.storage.IExposureStorage;
import io.github.mortuusars.exposure.data.transfer.IExposureReceiver;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;

public class ExposureReceiver
implements IExposureReceiver {
    private final Map<String, byte[]> PARTS = new HashMap<String, byte[]>();
    private final IExposureStorage storage;

    public ExposureReceiver(IExposureStorage storage) {
        this.storage = storage;
    }

    @Override
    public void receivePart(String id, int width, int height, CompoundTag properties, int offset, byte[] partBytes) {
        byte[] exposureBytes = this.PARTS.compute(id, (key, data) -> data == null ? new byte[width * height] : data);
        System.arraycopy(partBytes, 0, exposureBytes, offset, partBytes.length);
        this.PARTS.put(id, exposureBytes);
        if (offset + partBytes.length >= exposureBytes.length) {
            this.PARTS.remove(id);
            this.storage.put(id, new ExposureSavedData(width, height, exposureBytes, properties));
        }
    }
}

