/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.command.exposure;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import io.github.mortuusars.exposure.ExposureServer;
import io.github.mortuusars.exposure.command.argument.TextureLocationArgument;
import io.github.mortuusars.exposure.command.suggestion.ExposureIdSuggestionProvider;
import io.github.mortuusars.exposure.data.storage.ExposureSavedData;
import io.github.mortuusars.exposure.network.Packets;
import io.github.mortuusars.exposure.network.packet.client.ShowExposureS2CP;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class ShowCommand {
    public static LiteralArgumentBuilder<CommandSourceStack> get() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"show").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"latest").executes(context -> ShowCommand.latest((CommandSourceStack)context.getSource(), false))).then(Commands.m_82127_((String)"negative").executes(context -> ShowCommand.latest((CommandSourceStack)context.getSource(), true))))).then(Commands.m_82127_((String)"id").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"id", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new ExposureIdSuggestionProvider()).executes(context -> ShowCommand.exposureId((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"id"), false))).then(Commands.m_82127_((String)"negative").executes(context -> ShowCommand.exposureId((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"id"), true)))))).then(Commands.m_82127_((String)"texture").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"path", (ArgumentType)new TextureLocationArgument()).executes(context -> ShowCommand.texture((CommandSourceStack)context.getSource(), ResourceLocationArgument.m_107011_((CommandContext)context, (String)"path"), false))).then(Commands.m_82127_((String)"negative").executes(context -> ShowCommand.texture((CommandSourceStack)context.getSource(), ResourceLocationArgument.m_107011_((CommandContext)context, (String)"path"), true)))));
    }

    private static int latest(CommandSourceStack stack, boolean negative) {
        ServerPlayer player = stack.m_230896_();
        if (player == null) {
            stack.m_81352_((Component)Component.m_237115_((String)"command.exposure.show.error.not_a_player"));
            return 1;
        }
        Packets.sendToClient(ShowExposureS2CP.latest(negative), player);
        return 0;
    }

    private static int exposureId(CommandSourceStack stack, String id, boolean negative) {
        ServerPlayer player = stack.m_230896_();
        if (player == null) {
            stack.m_81352_((Component)Component.m_237115_((String)"command.exposure.show.error.not_a_player"));
            return 1;
        }
        Optional<ExposureSavedData> exposureData = ExposureServer.getExposureStorage().getOrQuery(id);
        if (exposureData.isEmpty()) {
            stack.m_81352_((Component)Component.m_237110_((String)"command.exposure.show.error.not_found", (Object[])new Object[]{id}));
            return 0;
        }
        ExposureServer.getExposureSender().sendTo((Player)player, id, exposureData.get());
        Packets.sendToClient(ShowExposureS2CP.id(id, negative), player);
        return 0;
    }

    private static int texture(CommandSourceStack stack, ResourceLocation path, boolean negative) {
        ServerPlayer player = stack.m_230896_();
        if (player == null) {
            stack.m_81352_((Component)Component.m_237115_((String)"command.exposure.show.error.not_a_player"));
            return 1;
        }
        Packets.sendToClient(ShowExposureS2CP.texture(path.toString(), negative), player);
        return 0;
    }
}

