/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.command.exposure;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.logging.LogUtils;
import io.github.mortuusars.exposure.ExposureServer;
import io.github.mortuusars.exposure.command.argument.ExposureLookArgument;
import io.github.mortuusars.exposure.command.argument.ExposureSizeArgument;
import io.github.mortuusars.exposure.command.suggestion.ExposureIdSuggestionProvider;
import io.github.mortuusars.exposure.data.ExposureLook;
import io.github.mortuusars.exposure.data.ExposureSize;
import io.github.mortuusars.exposure.data.storage.ExposureExporter;
import io.github.mortuusars.exposure.data.storage.ExposureSavedData;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.storage.LevelResource;
import org.jetbrains.annotations.NotNull;

public class ExportCommand {
    public static LiteralArgumentBuilder<CommandSourceStack> get() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"export").requires(stack -> stack.m_6761_(3))).then(ExportCommand.id())).then(ExportCommand.all());
    }

    private static ArgumentBuilder<CommandSourceStack, ?> id() {
        return Commands.m_82127_((String)"id").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"id", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new ExposureIdSuggestionProvider()).executes(context -> ExportCommand.exportExposures((CommandSourceStack)context.getSource(), List.of(StringArgumentType.getString((CommandContext)context, (String)"id")), ExposureSize.X1, ExposureLook.REGULAR))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"size", (ArgumentType)new ExposureSizeArgument()).executes(context -> ExportCommand.exportExposures((CommandSourceStack)context.getSource(), List.of(StringArgumentType.getString((CommandContext)context, (String)"id")), ExposureSizeArgument.getSize(context, "size"), ExposureLook.REGULAR))).then(Commands.m_82129_((String)"look", (ArgumentType)new ExposureLookArgument()).executes(context -> ExportCommand.exportExposures((CommandSourceStack)context.getSource(), List.of(StringArgumentType.getString((CommandContext)context, (String)"id")), ExposureSizeArgument.getSize(context, "size"), ExposureLookArgument.getLook(context, "look"))))));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> all() {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"all").executes(context -> ExportCommand.exportAll((CommandSourceStack)context.getSource(), ExposureSize.X1, ExposureLook.REGULAR))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"size", (ArgumentType)new ExposureSizeArgument()).executes(context -> ExportCommand.exportAll((CommandSourceStack)context.getSource(), ExposureSizeArgument.getSize(context, "size"), ExposureLook.REGULAR))).then(Commands.m_82129_((String)"look", (ArgumentType)new ExposureLookArgument()).executes(context -> ExportCommand.exportAll((CommandSourceStack)context.getSource(), ExposureSizeArgument.getSize(context, "size"), ExposureLookArgument.getLook(context, "look")))));
    }

    private static int exportAll(CommandSourceStack source, ExposureSize size, ExposureLook look) {
        List<String> ids = ExposureServer.getExposureStorage().getAllIds();
        return ExportCommand.exportExposures(source, ids, size, look);
    }

    private static int exportExposures(CommandSourceStack stack, List<String> exposureIds, ExposureSize size, ExposureLook look) {
        int savedCount = 0;
        File folder = stack.m_81377_().m_129843_(LevelResource.f_78182_).resolve("exposures").toFile();
        boolean ignored = folder.mkdirs();
        for (String id : exposureIds) {
            Optional<ExposureSavedData> data = ExposureServer.getExposureStorage().getOrQuery(id);
            if (data.isEmpty()) {
                stack.m_81352_((Component)Component.m_237110_((String)"command.exposure.export.failure.not_found", (Object[])new Object[]{id}));
                continue;
            }
            ExposureSavedData exposureSavedData = data.get();
            String name = id + look.getIdSuffix();
            boolean saved = new ExposureExporter(name).withFolder(folder.getAbsolutePath()).withModifier(look.getModifier()).withSize(size).save(exposureSavedData);
            if (saved) {
                stack.m_288197_(() -> Component.m_237110_((String)"command.exposure.export.success.saved_exposure_id", (Object[])new Object[]{id}), true);
            }
            ++savedCount;
        }
        if (savedCount > 0) {
            String folderPath = ExportCommand.getFolderPath(folder);
            MutableComponent folderComponent = Component.m_237113_((String)folderPath).m_130940_(ChatFormatting.UNDERLINE).m_130938_(arg -> arg.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_FILE, folderPath)));
            MutableComponent component = Component.m_237110_((String)"command.exposure.export.success.result", (Object[])new Object[]{savedCount, folderComponent});
            stack.m_288197_(() -> ExportCommand.lambda$exportExposures$9((Component)component), true);
        } else {
            stack.m_81352_((Component)Component.m_237115_((String)"command.exposure.export.failure.none_saved"));
        }
        return 0;
    }

    @NotNull
    private static String getFolderPath(File folder) {
        String folderPath;
        try {
            folderPath = folder.getCanonicalPath();
        }
        catch (IOException e) {
            LogUtils.getLogger().error(e.toString());
            folderPath = folder.getAbsolutePath();
        }
        return folderPath;
    }

    private static /* synthetic */ Component lambda$exportExposures$9(Component component) {
        return component;
    }
}

