/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.camera.capture.processing;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.util.Mth;
import net.minecraft.world.level.material.MapColor;

public class FloydDither {
    private static final double[] shadeCoeffs = new double[]{0.71, 0.86, 1.0, 0.53};

    public static byte[] ditherWithMapColors(BufferedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        int[][] pixels = FloydDither.convertToPixelArray(image);
        MapColor[] mapColors = (MapColor[])Arrays.stream(FloydDither.getMapColors()).filter(Objects::nonNull).toArray(MapColor[]::new);
        byte[] bytes = new byte[width * height];
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                byte b;
                Color imageColor = new Color(pixels[y][x], false);
                bytes[x + y * width] = b = (byte)FloydDither.floydDither(mapColors, pixels, x, y, imageColor);
            }
        }
        return bytes;
    }

    private static int floydDither(MapColor[] mapColors, int[][] pixels, int x, int y, Color imageColor) {
        Color pixelColor;
        int colorIndex = FloydDither.nearestColor(mapColors, imageColor);
        Color palletedColor = FloydDither.mapColorToRGBColor(mapColors, colorIndex);
        NegatableColor error = new NegatableColor(imageColor.getRed() - palletedColor.getRed(), imageColor.getGreen() - palletedColor.getGreen(), imageColor.getBlue() - palletedColor.getBlue());
        if (pixels[0].length > x + 1) {
            pixelColor = new Color(pixels[y][x + 1], true);
            pixels[y][x + 1] = FloydDither.applyError(pixelColor, error, 0.4375);
        }
        if (pixels.length > y + 1) {
            if (x > 0) {
                pixelColor = new Color(pixels[y + 1][x - 1], true);
                pixels[y + 1][x - 1] = FloydDither.applyError(pixelColor, error, 0.1875);
            }
            pixelColor = new Color(pixels[y + 1][x], true);
            pixels[y + 1][x] = FloydDither.applyError(pixelColor, error, 0.3125);
            if (pixels[0].length > x + 1) {
                pixelColor = new Color(pixels[y + 1][x + 1], true);
                pixels[y + 1][x + 1] = FloydDither.applyError(pixelColor, error, 0.0625);
            }
        }
        return colorIndex;
    }

    private static int applyError(Color pixelColor, NegatableColor error, double quantConst) {
        int pR = Mth.m_14045_((int)(pixelColor.getRed() + (int)((double)error.r * quantConst)), (int)0, (int)255);
        int pG = Mth.m_14045_((int)(pixelColor.getGreen() + (int)((double)error.g * quantConst)), (int)0, (int)255);
        int pB = Mth.m_14045_((int)(pixelColor.getBlue() + (int)((double)error.b * quantConst)), (int)0, (int)255);
        return new Color(pR, pG, pB, pixelColor.getAlpha()).getRGB();
    }

    private static Color mapColorToRGBColor(MapColor[] colors, int color) {
        Color mcColor = new Color(colors[color >> 2].f_283871_);
        double[] mcColorVec = new double[]{mcColor.getRed(), mcColor.getGreen(), mcColor.getBlue()};
        double coeff = shadeCoeffs[color & 3];
        return new Color((int)(mcColorVec[0] * coeff), (int)(mcColorVec[1] * coeff), (int)(mcColorVec[2] * coeff));
    }

    public static MapColor[] getMapColors() {
        MapColor[] colors = new MapColor[64];
        for (int i = 0; i <= 63; ++i) {
            colors[i] = MapColor.m_284175_((int)i);
        }
        return colors;
    }

    private static double[] applyShade(double[] color, int ind) {
        double coeff = shadeCoeffs[ind];
        return new double[]{color[0] * coeff, color[1] * coeff, color[2] * coeff};
    }

    private static int nearestColor(MapColor[] colors, Color imageColor) {
        double[] imageVec = new double[]{(double)imageColor.getRed() / 255.0, (double)imageColor.getGreen() / 255.0, (double)imageColor.getBlue() / 255.0};
        int best_color = 0;
        double lowest_distance = 10000.0;
        for (int k = 0; k < colors.length; ++k) {
            Color mcColor = new Color(colors[k].f_283871_);
            double[] mcColorVec = new double[]{(double)mcColor.getRed() / 255.0, (double)mcColor.getGreen() / 255.0, (double)mcColor.getBlue() / 255.0};
            for (int shadeInd = 0; shadeInd < shadeCoeffs.length; ++shadeInd) {
                double distance = FloydDither.distance(imageVec, FloydDither.applyShade(mcColorVec, shadeInd));
                if (!(distance < lowest_distance)) continue;
                lowest_distance = distance;
                best_color = k == 0 && imageColor.getAlpha() == 255 ? 119 : k * shadeCoeffs.length + shadeInd;
            }
        }
        return best_color;
    }

    private static double distance(double[] vectorA, double[] vectorB) {
        return Math.sqrt(Math.pow(vectorA[0] - vectorB[0], 2.0) + Math.pow(vectorA[1] - vectorB[1], 2.0) + Math.pow(vectorA[2] - vectorB[2], 2.0));
    }

    private static int[][] convertToPixelArray(BufferedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        int[][] result = new int[height][width];
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int rgb;
                result[y][x] = rgb = image.getRGB(x, y);
            }
        }
        return result;
    }

    private record NegatableColor(int r, int g, int b) {
    }
}

