/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.block.entity;

import com.google.common.base.Preconditions;
import com.mojang.logging.LogUtils;
import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.ExposureServer;
import io.github.mortuusars.exposure.block.LightroomBlock;
import io.github.mortuusars.exposure.block.entity.Lightroom;
import io.github.mortuusars.exposure.camera.infrastructure.FilmType;
import io.github.mortuusars.exposure.item.ChromaticSheetItem;
import io.github.mortuusars.exposure.item.DevelopedFilmItem;
import io.github.mortuusars.exposure.item.IFilmItem;
import io.github.mortuusars.exposure.item.PhotographItem;
import io.github.mortuusars.exposure.item.StackedPhotographsItem;
import io.github.mortuusars.exposure.menu.LightroomMenu;
import io.github.mortuusars.exposure.util.ItemAndStack;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LightroomBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer {
    public static final int CONTAINER_DATA_SIZE = 3;
    public static final int CONTAINER_DATA_PROGRESS_ID = 0;
    public static final int CONTAINER_DATA_PRINT_TIME_ID = 1;
    public static final int CONTAINER_DATA_SELECTED_FRAME_ID = 2;
    protected final ContainerData containerData = new ContainerData(){

        public int m_6413_(int id) {
            return switch (id) {
                case 0 -> LightroomBlockEntity.this.progress;
                case 1 -> LightroomBlockEntity.this.printTime;
                case 2 -> LightroomBlockEntity.this.getSelectedFrameIndex();
                default -> 0;
            };
        }

        public void m_8050_(int id, int value) {
            if (id == 0) {
                LightroomBlockEntity.this.progress = value;
            } else if (id == 1) {
                LightroomBlockEntity.this.printTime = value;
            } else if (id == 2) {
                LightroomBlockEntity.this.setSelectedFrame(value);
            }
            LightroomBlockEntity.this.m_6596_();
        }

        public int m_6499_() {
            return 3;
        }
    };
    protected NonNullList<ItemStack> items = NonNullList.m_122780_((int)7, (Object)ItemStack.f_41583_);
    protected int selectedFrame;
    protected int progress;
    protected int printTime;
    protected int storedExperience;
    protected boolean advanceFrame;
    protected Lightroom.Process process = Lightroom.Process.REGULAR;

    public LightroomBlockEntity(BlockPos pos, BlockState blockState) {
        super(Exposure.BlockEntityTypes.LIGHTROOM.get(), pos, blockState);
    }

    public static <T extends BlockEntity> void serverTick(Level level, BlockPos blockPos, BlockState blockState, T blockEntity) {
        if (blockEntity instanceof LightroomBlockEntity) {
            LightroomBlockEntity lightroomBlockEntity = (LightroomBlockEntity)blockEntity;
            lightroomBlockEntity.tick();
        }
    }

    protected void tick() {
        if (this.printTime <= 0 || !this.canPrint()) {
            this.stopPrintingProcess();
            return;
        }
        if (this.progress < this.printTime) {
            ++this.progress;
            if (this.progress % 55 == 0 && this.printTime - this.progress > 12 && this.f_58857_ != null) {
                this.f_58857_.m_5594_(null, this.m_58899_(), Exposure.SoundEvents.LIGHTROOM_PRINT.get(), SoundSource.BLOCKS, 1.0f, this.f_58857_.m_213780_().m_188501_() * 0.3f + 1.0f);
            }
            return;
        }
        if (this.tryPrint()) {
            this.onFramePrinted();
        }
        this.stopPrintingProcess();
    }

    protected void onFramePrinted() {
        if (this.advanceFrame) {
            this.advanceFrame();
        }
    }

    protected void advanceFrame() {
        ItemAndStack film = new ItemAndStack(this.m_8020_(0));
        int frames = ((DevelopedFilmItem)film.getItem()).getExposedFramesCount(film.getStack());
        if (this.getSelectedFrameIndex() >= frames - 1) {
            if (this.canEjectFilm()) {
                this.ejectFilm();
            }
        } else {
            this.setSelectedFrame(this.getSelectedFrameIndex() + 1);
            this.m_6596_();
        }
    }

    public boolean isAdvancingFrameOnPrint() {
        return this.advanceFrame;
    }

    protected boolean canEjectFilm() {
        Direction facing;
        if (this.f_58857_ == null || this.f_58857_.f_46443_ || this.m_8020_(0).m_41619_()) {
            return false;
        }
        BlockPos pos = this.m_58899_();
        return !this.f_58857_.m_8055_(pos.m_121945_(facing = (Direction)this.f_58857_.m_8055_(pos).m_61143_((Property)LightroomBlock.FACING))).m_60815_();
    }

    protected void ejectFilm() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_ || this.m_8020_(0).m_41619_()) {
            return;
        }
        BlockPos pos = this.m_58899_();
        Direction facing = (Direction)this.f_58857_.m_8055_(pos).m_61143_((Property)LightroomBlock.FACING);
        ItemStack filmStack = this.m_7407_(0, 1);
        Vec3i normal = facing.m_122436_();
        Vec3 point = Vec3.m_82512_((Vec3i)pos).m_82520_((double)((float)normal.m_123341_() * 0.75f), (double)((float)normal.m_123342_() * 0.75f), (double)((float)normal.m_123343_() * 0.75f));
        ItemEntity itemEntity = new ItemEntity(this.f_58857_, point.f_82479_, point.f_82480_, point.f_82481_, filmStack);
        itemEntity.m_20334_((double)((float)normal.m_123341_() * 0.05f), (double)((float)normal.m_123342_() * 0.05f + 0.15f), (double)((float)normal.m_123343_() * 0.05f));
        itemEntity.m_32060_();
        this.f_58857_.m_7967_((Entity)itemEntity);
        this.inventoryContentsChanged(0);
    }

    public int getSelectedFrameIndex() {
        return this.selectedFrame;
    }

    public void setSelectedFrame(int index) {
        if (this.selectedFrame != index) {
            this.selectedFrame = index;
            this.stopPrintingProcess();
        }
    }

    public Lightroom.Process getProcess() {
        return this.process;
    }

    public Lightroom.Process getActualProcess(ItemStack filmStack) {
        ItemStack film = this.m_8020_(0);
        if (!this.isSelectedFrameChromatic(film, this.getSelectedFrameIndex())) {
            return Lightroom.Process.REGULAR;
        }
        return this.process;
    }

    public void setProcess(Lightroom.Process process) {
        this.process = process;
        this.stopPrintingProcess();
        this.m_6596_();
    }

    public Optional<CompoundTag> getSelectedFrame(ItemStack film) {
        DevelopedFilmItem developedFilm;
        ListTag frames;
        Item item;
        if (!film.m_41619_() && (item = film.m_41720_()) instanceof DevelopedFilmItem && (frames = (developedFilm = (DevelopedFilmItem)item).getExposedFrames(film)).size() > this.getSelectedFrameIndex()) {
            return Optional.of(frames.m_128728_(this.selectedFrame));
        }
        return Optional.empty();
    }

    public boolean isSelectedFrameChromatic(ItemStack film, int selectedFrame) {
        return this.getSelectedFrame(film).map(frame -> frame.m_128471_("Chromatic")).orElse(false);
    }

    public void startPrintingProcess(boolean advanceFrameOnFinish) {
        if (!this.canPrint()) {
            return;
        }
        ItemStack filmStack = this.m_8020_(0);
        Item item = filmStack.m_41720_();
        if (!(item instanceof DevelopedFilmItem)) {
            return;
        }
        DevelopedFilmItem film = (DevelopedFilmItem)item;
        this.printTime = this.getActualProcess(filmStack) == Lightroom.Process.CHROMATIC ? (Integer)Config.Common.LIGHTROOM_CHROMATIC_PRINT_TIME.get() : (film.getType() == FilmType.BLACK_AND_WHITE ? ((Integer)Config.Common.LIGHTROOM_BW_PRINT_TIME.get()).intValue() : ((Integer)Config.Common.LIGHTROOM_COLOR_PRINT_TIME.get()).intValue());
        this.advanceFrame = advanceFrameOnFinish;
        if (this.f_58857_ != null) {
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.f_58857_.m_8055_(this.m_58899_()).m_61124_((Property)LightroomBlock.LIT, (Comparable)Boolean.valueOf(true)), 2);
            this.f_58857_.m_5594_(null, this.m_58899_(), Exposure.SoundEvents.LIGHTROOM_PRINT.get(), SoundSource.BLOCKS, 1.0f, this.f_58857_.m_213780_().m_188501_() * 0.3f + 1.0f);
        }
    }

    public void stopPrintingProcess() {
        this.progress = 0;
        this.printTime = 0;
        this.advanceFrame = false;
        if (this.f_58857_ != null && this.f_58857_.m_8055_(this.m_58899_()).m_60734_() instanceof LightroomBlock) {
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.f_58857_.m_8055_(this.m_58899_()).m_61124_((Property)LightroomBlock.LIT, (Comparable)Boolean.valueOf(false)), 2);
        }
    }

    public boolean isPrinting() {
        return this.printTime > 0;
    }

    public boolean canPrint() {
        DevelopedFilmItem developedFilm;
        if (this.getSelectedFrameIndex() < 0) {
            return false;
        }
        ItemStack filmStack = this.m_8020_(0);
        Item item = filmStack.m_41720_();
        if (!(item instanceof DevelopedFilmItem) || !(developedFilm = (DevelopedFilmItem)item).hasExposedFrame(filmStack, this.getSelectedFrameIndex())) {
            return false;
        }
        Lightroom.Process process = this.getActualProcess(filmStack);
        ItemStack paperStack = this.m_8020_(1);
        return this.isPaperValidForPrint(paperStack, filmStack, process) && this.hasDyesForPrint(filmStack, paperStack, process) && this.canOutputToResultSlot(this.m_8020_(6), filmStack, process);
    }

    public boolean canPrintInCreativeMode() {
        DevelopedFilmItem developedFilm;
        if (this.getSelectedFrameIndex() < 0) {
            return false;
        }
        ItemStack filmStack = this.m_8020_(0);
        Item item = filmStack.m_41720_();
        if (!(item instanceof DevelopedFilmItem) || !(developedFilm = (DevelopedFilmItem)item).hasExposedFrame(filmStack, this.getSelectedFrameIndex())) {
            return false;
        }
        return this.canOutputToResultSlot(this.m_8020_(6), filmStack, this.getActualProcess(filmStack));
    }

    protected boolean isPaperValidForPrint(ItemStack paperStack, ItemStack filmStack, Lightroom.Process process) {
        if (paperStack.m_41619_()) {
            return false;
        }
        return process != Lightroom.Process.REGULAR || paperStack.m_204117_(Exposure.Tags.Items.PHOTO_PAPERS);
    }

    protected boolean hasDyesForPrint(ItemStack film, ItemStack paper, Lightroom.Process process) {
        int[] dyeSlots;
        for (int slot : dyeSlots = this.getRequiredDyeSlotsForPrint(film, paper, process)) {
            if (!this.m_8020_(slot).m_41619_()) continue;
            return false;
        }
        return true;
    }

    public boolean canOutputToResultSlot(ItemStack resultStack, ItemStack filmStack, Lightroom.Process process) {
        StackedPhotographsItem stackedPhotographsItem;
        Item item;
        if (this.isSelectedFrameChromatic(filmStack, this.getSelectedFrameIndex()) && process == Lightroom.Process.CHROMATIC) {
            return resultStack.m_41619_();
        }
        return resultStack.m_41619_() || resultStack.m_41720_() instanceof PhotographItem || (item = resultStack.m_41720_()) instanceof StackedPhotographsItem && (stackedPhotographsItem = (StackedPhotographsItem)item).canAddPhotograph(resultStack);
    }

    protected int[] getRequiredDyeSlotsForPrint(ItemStack film, ItemStack paper, Lightroom.Process process) {
        Item item = film.m_41720_();
        if (!(item instanceof IFilmItem)) {
            return ArrayUtils.EMPTY_INT_ARRAY;
        }
        IFilmItem filmItem = (IFilmItem)item;
        if (process == Lightroom.Process.REGULAR) {
            return filmItem.getType() == FilmType.COLOR ? Lightroom.DYES_FOR_COLOR : Lightroom.DYES_FOR_BW;
        }
        if (process == Lightroom.Process.CHROMATIC) {
            int chromaticStep = this.getChromaticStep(paper);
            if (chromaticStep == 0) {
                return Lightroom.DYES_FOR_CHROMATIC_RED;
            }
            if (chromaticStep == 1) {
                return Lightroom.DYES_FOR_CHROMATIC_GREEN;
            }
            if (chromaticStep == 2) {
                return Lightroom.DYES_FOR_CHROMATIC_BLUE;
            }
        }
        return ArrayUtils.EMPTY_INT_ARRAY;
    }

    protected int getChromaticStep(ItemStack paper) {
        Item item = paper.m_41720_();
        if (!(item instanceof ChromaticSheetItem)) {
            return 0;
        }
        ChromaticSheetItem chromaticFragment = (ChromaticSheetItem)item;
        return chromaticFragment.getExposures(paper).size();
    }

    public boolean tryPrint() {
        String id;
        int[] dyesSlots;
        Preconditions.checkState((this.f_58857_ != null && !this.f_58857_.f_46443_ ? 1 : 0) != 0, (Object)"Cannot be called clientside.");
        if (!this.canPrint()) {
            return false;
        }
        ItemStack filmStack = this.m_8020_(0);
        Item item = filmStack.m_41720_();
        if (!(item instanceof DevelopedFilmItem)) {
            return false;
        }
        DevelopedFilmItem developedFilm = (DevelopedFilmItem)item;
        Optional<CompoundTag> selectedFrame = this.getSelectedFrame(filmStack);
        if (selectedFrame.isEmpty()) {
            LogUtils.getLogger().error("Unable to get selected frame '{}' : {}", (Object)this.getSelectedFrameIndex(), (Object)filmStack);
            return false;
        }
        CompoundTag frame = selectedFrame.get().m_6426_();
        Lightroom.Process process = this.getActualProcess(filmStack);
        ItemStack paperStack = this.m_8020_(1);
        ItemStack printResult = this.createPrintResult(frame, filmStack, paperStack, process);
        this.putPrintResultInOutputSlot(printResult);
        for (int slot : dyesSlots = this.getRequiredDyeSlotsForPrint(filmStack, paperStack, process)) {
            this.m_8020_(slot).m_41774_(1);
        }
        this.m_8020_(1).m_41774_(1);
        this.f_58857_.m_5594_(null, this.m_58899_(), Exposure.SoundEvents.PHOTOGRAPH_RUSTLE.get(), SoundSource.PLAYERS, 0.8f, 1.0f);
        this.storeExperienceForPrint(filmStack, frame, process, printResult);
        if (process != Lightroom.Process.CHROMATIC && !(id = frame.m_128461_("Id")).isEmpty()) {
            ExposureServer.getExposureStorage().getOrQuery(id).ifPresent(exposure -> {
                CompoundTag properties = exposure.getProperties();
                if (!properties.m_128471_("WasPrinted")) {
                    properties.m_128379_("WasPrinted", true);
                    exposure.m_77762_();
                }
            });
        }
        return true;
    }

    protected void storeExperienceForPrint(ItemStack film, CompoundTag frame, Lightroom.Process process, ItemStack result) {
        if (this.f_58857_ == null) {
            return;
        }
        int xp = 0;
        if (process == Lightroom.Process.CHROMATIC) {
            xp = result.m_41720_() instanceof ChromaticSheetItem ? 0 : (Integer)Config.Common.LIGHTROOM_EXPERIENCE_PER_PRINT_CHROMATIC.get();
        } else {
            Item item = film.m_41720_();
            if (item instanceof IFilmItem) {
                IFilmItem filmItem = (IFilmItem)item;
                xp = filmItem.getType() == FilmType.COLOR ? (Integer)Config.Common.LIGHTROOM_EXPERIENCE_PER_PRINT_COLOR.get() : (Integer)Config.Common.LIGHTROOM_EXPERIENCE_PER_PRINT_BW.get();
            }
        }
        if (xp > 0) {
            float variability = this.f_58857_.m_213780_().m_188501_() * 0.3f + 1.0f;
            int variableXp = (int)Math.max(1.0, Math.ceil((float)xp * variability));
            this.storedExperience += variableXp;
        }
    }

    public void printInCreativeMode() {
        String id;
        Preconditions.checkState((this.f_58857_ != null && !this.f_58857_.f_46443_ ? 1 : 0) != 0, (Object)"Cannot be called clientside.");
        if (!this.canPrintInCreativeMode()) {
            return;
        }
        ItemStack filmStack = this.m_8020_(0);
        Item item = filmStack.m_41720_();
        if (!(item instanceof DevelopedFilmItem)) {
            return;
        }
        DevelopedFilmItem developedFilm = (DevelopedFilmItem)item;
        Optional<CompoundTag> selectedFrame = this.getSelectedFrame(filmStack);
        if (selectedFrame.isEmpty()) {
            LogUtils.getLogger().error("Unable to get selected frame '{}' : {}", (Object)this.getSelectedFrameIndex(), (Object)filmStack);
            return;
        }
        CompoundTag frame = selectedFrame.get().m_6426_();
        Lightroom.Process process = this.getActualProcess(filmStack);
        ItemStack paperStack = this.m_8020_(1);
        ItemStack printResult = this.createPrintResult(frame, filmStack, paperStack, process);
        this.putPrintResultInOutputSlot(printResult);
        if (process == Lightroom.Process.CHROMATIC) {
            this.m_8020_(1).m_41774_(1);
        }
        this.f_58857_.m_5594_(null, this.m_58899_(), Exposure.SoundEvents.PHOTOGRAPH_RUSTLE.get(), SoundSource.PLAYERS, 0.8f, 1.0f);
        if (process != Lightroom.Process.CHROMATIC && !(id = frame.m_128461_("Id")).isEmpty()) {
            ExposureServer.getExposureStorage().getOrQuery(id).ifPresent(exposure -> {
                CompoundTag properties = exposure.getProperties();
                if (!properties.m_128471_("WasPrinted")) {
                    properties.m_128379_("WasPrinted", true);
                    exposure.m_77762_();
                }
            });
        }
    }

    protected void putPrintResultInOutputSlot(ItemStack printResult) {
        ItemStack resultStack = this.m_8020_(6);
        if (resultStack.m_41619_()) {
            resultStack = printResult;
        } else if (resultStack.m_41720_() instanceof PhotographItem) {
            StackedPhotographsItem stackedPhotographsItem = Exposure.Items.STACKED_PHOTOGRAPHS.get();
            ItemStack newStackedPhotographs = new ItemStack((ItemLike)stackedPhotographsItem);
            stackedPhotographsItem.addPhotographOnTop(newStackedPhotographs, resultStack);
            stackedPhotographsItem.addPhotographOnTop(newStackedPhotographs, printResult);
            resultStack = newStackedPhotographs;
        } else {
            Item item = resultStack.m_41720_();
            if (item instanceof StackedPhotographsItem) {
                StackedPhotographsItem stackedPhotographsItem = (StackedPhotographsItem)item;
                stackedPhotographsItem.addPhotographOnTop(resultStack, printResult);
            } else {
                LogUtils.getLogger().error("Unexpected item in result slot: " + resultStack);
                return;
            }
        }
        this.m_6836_(6, resultStack);
    }

    protected ItemStack createPrintResult(CompoundTag frame, ItemStack film, ItemStack paper, Lightroom.Process process) {
        Item item = film.m_41720_();
        if (!(item instanceof IFilmItem)) {
            throw new IllegalStateException("Film stack is invalid: " + film);
        }
        IFilmItem filmItem = (IFilmItem)item;
        paper = paper.m_41777_();
        frame.m_128359_("Type", process == Lightroom.Process.REGULAR ? filmItem.getType().m_7912_() : FilmType.COLOR.m_7912_());
        if (process == Lightroom.Process.CHROMATIC) {
            ItemAndStack chromaticFragment = new ItemAndStack(paper.m_41720_() instanceof ChromaticSheetItem ? paper : new ItemStack((ItemLike)Exposure.Items.CHROMATIC_SHEET.get()));
            ((ChromaticSheetItem)((Object)chromaticFragment.getItem())).addExposure(chromaticFragment.getStack(), frame);
            if (((ChromaticSheetItem)((Object)chromaticFragment.getItem())).getExposures(chromaticFragment.getStack()).size() >= 3) {
                return ((ChromaticSheetItem)((Object)chromaticFragment.getItem())).finalize(Objects.requireNonNull(this.f_58857_), chromaticFragment.getStack());
            }
            return chromaticFragment.getStack();
        }
        ItemStack photographStack = new ItemStack((ItemLike)Exposure.Items.PHOTOGRAPH.get());
        photographStack.m_41751_(frame);
        return photographStack;
    }

    public void dropStoredExperience(@Nullable Player player) {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.storedExperience > 0) {
                ExperienceOrb.m_147082_((ServerLevel)serverLevel, (Vec3)Vec3.m_82512_((Vec3i)this.m_58899_()), (int)this.storedExperience);
                this.storedExperience = 0;
                this.m_6596_();
            }
        }
    }

    @NotNull
    protected Component m_6820_() {
        return Component.m_237115_((String)"block.exposure.lightroom");
    }

    @NotNull
    protected AbstractContainerMenu m_6555_(int containerId, Inventory inventory) {
        return new LightroomMenu(containerId, inventory, this, this.containerData);
    }

    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        if (slot == 0) {
            return stack.m_41720_() instanceof DevelopedFilmItem;
        }
        if (slot == 2) {
            return stack.m_204117_(Exposure.Tags.Items.CYAN_PRINTING_DYES);
        }
        if (slot == 3) {
            return stack.m_204117_(Exposure.Tags.Items.MAGENTA_PRINTING_DYES);
        }
        if (slot == 4) {
            return stack.m_204117_(Exposure.Tags.Items.YELLOW_PRINTING_DYES);
        }
        if (slot == 5) {
            return stack.m_204117_(Exposure.Tags.Items.BLACK_PRINTING_DYES);
        }
        if (slot == 1) {
            ChromaticSheetItem chromatic;
            Item item;
            return stack.m_204117_(Exposure.Tags.Items.PHOTO_PAPERS) || (item = stack.m_41720_()) instanceof ChromaticSheetItem && (chromatic = (ChromaticSheetItem)item).getExposures(stack).size() < 3;
        }
        if (slot == 6) {
            return stack.m_41720_() instanceof PhotographItem || stack.m_41720_() instanceof ChromaticSheetItem;
        }
        return false;
    }

    protected void inventoryContentsChanged(int slot) {
        if (slot == 0) {
            this.setSelectedFrame(0);
        }
        this.m_6596_();
    }

    public boolean m_6542_(@NotNull Player player) {
        return this.f_58857_ != null && this.f_58857_.m_7702_(this.f_58858_) == this && player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public int @NotNull [] m_7071_(@NotNull Direction face) {
        return Lightroom.ALL_SLOTS;
    }

    public boolean m_7155_(int index, @NotNull ItemStack itemStack, @Nullable Direction direction) {
        if (direction == Direction.DOWN) {
            return false;
        }
        return this.m_7013_(index, itemStack);
    }

    public boolean m_7013_(int index, ItemStack stack) {
        return index != 6 && this.isItemValidForSlot(index, stack) && super.m_7013_(index, stack);
    }

    public boolean m_7157_(int index, @NotNull ItemStack pStack, @NotNull Direction direction) {
        for (int outputSlot : Lightroom.OUTPUT_SLOTS) {
            if (index != outputSlot) continue;
            return true;
        }
        return false;
    }

    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)tag, this.items);
        if (tag.m_128425_("Inventory", 10)) {
            CompoundTag inventory = tag.m_128469_("Inventory");
            ListTag itemsList = inventory.m_128437_("Items", 10);
            for (int i = 0; i < itemsList.size(); ++i) {
                CompoundTag itemTags = itemsList.m_128728_(i);
                int slot = itemTags.m_128451_("Slot");
                if (slot < 0 || slot >= this.items.size()) continue;
                this.items.set(slot, (Object)ItemStack.m_41712_((CompoundTag)itemTags));
            }
        }
        this.setSelectedFrame(tag.m_128451_("SelectedFrame"));
        this.progress = tag.m_128451_("Progress");
        this.printTime = tag.m_128451_("PrintTime");
        this.storedExperience = tag.m_128451_("PrintedPhotographsCount");
        this.advanceFrame = tag.m_128471_("AdvanceFrame");
        this.process = Lightroom.Process.fromStringOrDefault(tag.m_128461_("Process"), Lightroom.Process.REGULAR);
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        ContainerHelper.m_18973_((CompoundTag)tag, this.items);
        if (this.getSelectedFrameIndex() > 0) {
            tag.m_128405_("SelectedFrame", this.getSelectedFrameIndex());
        }
        if (this.progress > 0) {
            tag.m_128405_("Progress", this.progress);
        }
        if (this.printTime > 0) {
            tag.m_128405_("PrintTime", this.printTime);
        }
        if (this.storedExperience > 0) {
            tag.m_128405_("PrintedPhotographsCount", this.storedExperience);
        }
        if (this.advanceFrame) {
            tag.m_128379_("AdvanceFrame", true);
        }
        if (this.process != Lightroom.Process.REGULAR) {
            tag.m_128359_("Process", this.process.m_7912_());
        }
    }

    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public int m_6643_() {
        return 7;
    }

    public boolean m_7983_() {
        return this.getItems().stream().allMatch(ItemStack::m_41619_);
    }

    @NotNull
    public ItemStack m_8020_(int slot) {
        return (ItemStack)this.getItems().get(slot);
    }

    @NotNull
    public ItemStack m_7407_(int slot, int amount) {
        ItemStack itemStack = ContainerHelper.m_18969_(this.getItems(), (int)slot, (int)amount);
        if (!itemStack.m_41619_()) {
            this.inventoryContentsChanged(slot);
        }
        return itemStack;
    }

    @NotNull
    public ItemStack m_8016_(int slot) {
        return ContainerHelper.m_18966_(this.getItems(), (int)slot);
    }

    public void m_6836_(int slot, ItemStack stack) {
        this.getItems().set(slot, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
        this.inventoryContentsChanged(slot);
    }

    public void m_6211_() {
        this.getItems().clear();
        this.inventoryContentsChanged(-1);
    }

    public void m_6596_() {
        super.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
        }
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187482_();
    }
}

