/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.advancement.trigger;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.advancement.predicate.ExposurePredicate;
import io.github.mortuusars.exposure.item.CameraItem;
import io.github.mortuusars.exposure.util.ItemAndStack;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;

public class CameraFilmFrameExposedTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    public static final ResourceLocation ID = Exposure.resource("frame_exposed");

    @NotNull
    public ResourceLocation m_7295_() {
        return ID;
    }

    @NotNull
    protected TriggerInstance createInstance(JsonObject json, @NotNull ContextAwarePredicate predicate, @NotNull DeserializationContext deserializationContext) {
        LocationPredicate location = LocationPredicate.m_52629_((JsonElement)json.get("location"));
        ExposurePredicate exposure = ExposurePredicate.fromJson(json.get("exposure"));
        return new TriggerInstance(predicate, location, exposure);
    }

    public void trigger(ServerPlayer player, ItemAndStack<CameraItem> camera, CompoundTag frame) {
        this.m_66234_(player, triggerInstance -> triggerInstance.matches(player, camera, frame));
    }

    public static class TriggerInstance
    extends AbstractCriterionTriggerInstance {
        private final LocationPredicate locationPredicate;
        private final ExposurePredicate exposurePredicate;

        public TriggerInstance(ContextAwarePredicate predicate, LocationPredicate locationPredicate, ExposurePredicate exposurePredicate) {
            super(ID, predicate);
            this.locationPredicate = locationPredicate;
            this.exposurePredicate = exposurePredicate;
        }

        public boolean matches(ServerPlayer player, ItemAndStack<CameraItem> camera, CompoundTag frame) {
            if (!this.locationPredicate.m_52617_(player.m_284548_(), player.m_20185_(), player.m_20186_(), player.m_20189_())) {
                return false;
            }
            return this.exposurePredicate.matches(player, frame);
        }

        @NotNull
        public JsonObject m_7683_(@NotNull SerializationContext conditions) {
            JsonObject jsonobject = super.m_7683_(conditions);
            if (this.exposurePredicate != ExposurePredicate.ANY) {
                jsonobject.add("exposure", this.exposurePredicate.serializeToJson());
            }
            if (this.locationPredicate != LocationPredicate.f_52592_) {
                jsonobject.add("location", this.locationPredicate.m_52616_());
            }
            return jsonobject;
        }
    }
}

