/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.platform.InputConstants;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.camera.viewfinder.ViewfinderClient;
import io.github.mortuusars.exposure.data.storage.ClientsideExposureStorage;
import io.github.mortuusars.exposure.data.storage.IClientsideExposureStorage;
import io.github.mortuusars.exposure.data.transfer.ExposureReceiver;
import io.github.mortuusars.exposure.data.transfer.ExposureSender;
import io.github.mortuusars.exposure.data.transfer.IExposureReceiver;
import io.github.mortuusars.exposure.data.transfer.IExposureSender;
import io.github.mortuusars.exposure.gui.screen.camera.ViewfinderControlsScreen;
import io.github.mortuusars.exposure.item.AlbumItem;
import io.github.mortuusars.exposure.item.CameraItemClientExtensions;
import io.github.mortuusars.exposure.item.ChromaticSheetItem;
import io.github.mortuusars.exposure.item.StackedPhotographsItem;
import io.github.mortuusars.exposure.network.Packets;
import io.github.mortuusars.exposure.render.ExposureRenderer;
import io.github.mortuusars.exposure.util.CameraInHand;
import java.util.function.Function;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.Nullable;

public class ExposureClient {
    private static final IClientsideExposureStorage exposureStorage = new ClientsideExposureStorage();
    private static final ExposureRenderer exposureRenderer = new ExposureRenderer();
    private static IExposureSender exposureSender;
    private static IExposureReceiver exposureReceiver;
    @Nullable
    private static KeyMapping openViewfinderControlsKey;

    public static void init() {
        exposureSender = new ExposureSender((packet, player) -> Packets.sendToServer(packet));
        exposureReceiver = new ExposureReceiver(exposureStorage);
        ItemProperties.m_174570_((Item)Exposure.Items.CAMERA.get(), (ResourceLocation)new ResourceLocation("camera_state"), CameraItemClientExtensions::itemPropertyFunction);
        ItemProperties.m_174570_((Item)Exposure.Items.CHROMATIC_SHEET.get(), (ResourceLocation)new ResourceLocation("channels"), (stack, clientLevel, livingEntity, seed) -> {
            float f;
            Item patt2548$temp = stack.m_41720_();
            if (patt2548$temp instanceof ChromaticSheetItem) {
                ChromaticSheetItem chromaticSheet = (ChromaticSheetItem)patt2548$temp;
                f = (float)chromaticSheet.getExposures(stack).size() / 10.0f;
            } else {
                f = 0.0f;
            }
            return f;
        });
        ItemProperties.m_174570_((Item)Exposure.Items.STACKED_PHOTOGRAPHS.get(), (ResourceLocation)new ResourceLocation("count"), (stack, clientLevel, livingEntity, seed) -> {
            float f;
            Item patt2883$temp = stack.m_41720_();
            if (patt2883$temp instanceof StackedPhotographsItem) {
                StackedPhotographsItem stackedPhotographsItem = (StackedPhotographsItem)patt2883$temp;
                f = (float)stackedPhotographsItem.getPhotographsCount(stack) / 100.0f;
            } else {
                f = 0.0f;
            }
            return f;
        });
        ItemProperties.m_174570_((Item)Exposure.Items.ALBUM.get(), (ResourceLocation)new ResourceLocation("photos"), (stack, clientLevel, livingEntity, seed) -> {
            float f;
            Item patt3234$temp = stack.m_41720_();
            if (patt3234$temp instanceof AlbumItem) {
                AlbumItem albumItem = (AlbumItem)patt3234$temp;
                f = (float)albumItem.getPhotographsCount(stack) / 100.0f;
            } else {
                f = 0.0f;
            }
            return f;
        });
    }

    public static IClientsideExposureStorage getExposureStorage() {
        return exposureStorage;
    }

    public static IExposureSender getExposureSender() {
        return exposureSender;
    }

    public static IExposureReceiver getExposureReceiver() {
        return exposureReceiver;
    }

    public static ExposureRenderer getExposureRenderer() {
        return exposureRenderer;
    }

    public static void registerKeymappings(Function<KeyMapping, KeyMapping> registerFunction) {
        KeyMapping keyMapping = new KeyMapping("key.exposure.camera_controls", InputConstants.f_84822_.m_84873_(), "category.exposure");
        openViewfinderControlsKey = registerFunction.apply(keyMapping);
    }

    public static void onScreenAdded(Screen screen) {
        LocalPlayer player;
        if (ViewfinderClient.isOpen() && !(screen instanceof ViewfinderControlsScreen) && (player = Minecraft.m_91087_().f_91074_) != null) {
            CameraInHand.deactivate((Player)player);
        }
    }

    public static KeyMapping getViewfinderControlsKey() {
        Preconditions.checkState((openViewfinderControlsKey != null ? 1 : 0) != 0, (Object)"Viewfinder Controls key mapping was not registered");
        return openViewfinderControlsKey.m_90862_() ? Minecraft.m_91087_().f_91066_.f_92090_ : openViewfinderControlsKey;
    }

    static {
        openViewfinderControlsKey = null;
    }
}

