/*
 * Decompiled with CFR 0.152.
 */
package com.github.mnesikos.simplycats.worldgen.villages;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraftforge.event.server.ServerAboutToStartEvent;

public class SCWorldGen {
    private static final ResourceLocation desertShelterStructure = new ResourceLocation("simplycats", "village/desert_shelter_1");
    private static final ResourceLocation plainsShelterStructure = new ResourceLocation("simplycats", "village/plains_shelter_1");
    private static final ResourceLocation savannaShelterStructure = new ResourceLocation("simplycats", "village/savanna_shelter_1");
    private static final ResourceLocation snowyShelterStructure = new ResourceLocation("simplycats", "village/snowy_shelter_1");
    private static final ResourceLocation taigaShelterStructure = new ResourceLocation("simplycats", "village/taiga_shelter_1");

    public static void setupVillageWorldGen(ServerAboutToStartEvent event) {
        MinecraftServer server = event.getServer();
        Registry templatePoolRegistry = server.m_206579_().m_175515_(Registries.f_256948_);
        SCWorldGen.addStructureToVillage((StructureTemplatePool)templatePoolRegistry.m_7745_(new ResourceLocation("village/desert/houses")), (SinglePoolElement)SinglePoolElement.m_210526_((String)desertShelterStructure.toString()).apply(StructureTemplatePool.Projection.RIGID), 6);
        SCWorldGen.addStructureToVillage((StructureTemplatePool)templatePoolRegistry.m_7745_(new ResourceLocation("village/plains/houses")), (SinglePoolElement)SinglePoolElement.m_210526_((String)plainsShelterStructure.toString()).apply(StructureTemplatePool.Projection.RIGID), 6);
        SCWorldGen.addStructureToVillage((StructureTemplatePool)templatePoolRegistry.m_7745_(new ResourceLocation("village/savanna/houses")), (SinglePoolElement)SinglePoolElement.m_210526_((String)savannaShelterStructure.toString()).apply(StructureTemplatePool.Projection.RIGID), 6);
        SCWorldGen.addStructureToVillage((StructureTemplatePool)templatePoolRegistry.m_7745_(new ResourceLocation("village/snowy/houses")), (SinglePoolElement)SinglePoolElement.m_210526_((String)snowyShelterStructure.toString()).apply(StructureTemplatePool.Projection.RIGID), 6);
        SCWorldGen.addStructureToVillage((StructureTemplatePool)templatePoolRegistry.m_7745_(new ResourceLocation("village/taiga/houses")), (SinglePoolElement)SinglePoolElement.m_210526_((String)taigaShelterStructure.toString()).apply(StructureTemplatePool.Projection.RIGID), 6);
    }

    private static <T extends StructurePoolElement> void addStructureToVillage(StructureTemplatePool pool, T piece, int weight) {
        if (pool == null) {
            return;
        }
        for (int i = 0; i < weight; ++i) {
            pool.f_210560_.add(piece);
        }
        ArrayList<Pair> listOfPieceEntries = new ArrayList<Pair>(pool.f_210559_);
        listOfPieceEntries.add(Pair.of(piece, (Object)weight));
        pool.f_210559_ = listOfPieceEntries;
    }
}

