/*
 * Decompiled with CFR 0.152.
 */
package com.github.mnesikos.simplycats.client.render.entity;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.FastColor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class LayeredTexture
extends AbstractTexture {
    public final String[] texturePaths;

    public LayeredTexture(String[] texturePaths) {
        this.texturePaths = texturePaths;
        if (this.texturePaths.length <= 0) {
            throw new IllegalStateException("No textures provided.");
        }
    }

    public void m_6704_(ResourceManager manager) throws IOException {
        NativeImage image = this.getLayer(manager, this.texturePaths);
        if (!RenderSystem.isOnRenderThreadOrInit()) {
            RenderSystem.recordRenderCall(() -> this.loadImage(image));
        } else {
            this.loadImage(image);
        }
    }

    public NativeImage getLayer(ResourceManager manager, String[] texturePaths) {
        List<String> layers = Arrays.asList(texturePaths);
        Iterator<String> iterator = layers.iterator();
        String baseLayer = iterator.next();
        NativeImage baseImage = this.tryLayer(manager, baseLayer);
        if (baseImage == null) {
            return null;
        }
        while (iterator.hasNext()) {
            NativeImage image;
            String layer = iterator.next();
            if (layer == null || (image = this.tryLayer(manager, layer)) == null) continue;
            this.blendLayer(baseImage, image);
        }
        return baseImage;
    }

    public NativeImage tryLayer(ResourceManager manager, String layer) {
        if (layer == null) {
            return null;
        }
        try {
            Resource resource = (Resource)manager.m_213713_(new ResourceLocation(layer)).orElseThrow();
            return NativeImage.m_85058_((InputStream)resource.m_215507_());
        }
        catch (IOException exception) {
            throw new IllegalStateException("Couldn't load texture layers.", exception);
        }
    }

    public void blendLayer(NativeImage base, NativeImage image) {
        for (int i = 0; i < image.m_85084_(); ++i) {
            for (int j = 0; j < image.m_84982_(); ++j) {
                int color = image.m_84985_(j, i);
                this.blendPixel(base, j, i, FastColor.ABGR32.m_266248_((int)FastColor.ABGR32.m_266503_((int)color), (int)FastColor.ABGR32.m_266247_((int)color), (int)FastColor.ABGR32.m_266446_((int)color), (int)FastColor.ABGR32.m_266313_((int)color)));
            }
        }
    }

    private void loadImage(NativeImage image) {
        TextureUtil.prepareImage((int)this.m_117963_(), (int)image.m_84982_(), (int)image.m_85084_());
        image.m_85040_(0, 0, 0, true);
    }

    public void blendPixel(NativeImage image, int x, int y, int color) {
        int baseColor = image.m_84985_(x, y);
        float a = (float)FastColor.ABGR32.m_266503_((int)color) / 255.0f;
        float blue = FastColor.ABGR32.m_266247_((int)color);
        float green = FastColor.ABGR32.m_266446_((int)color);
        float red = FastColor.ABGR32.m_266313_((int)color);
        float baseAlpha = (float)FastColor.ABGR32.m_266503_((int)baseColor) / 255.0f;
        float baseBlue = FastColor.ABGR32.m_266247_((int)baseColor);
        float baseGreen = FastColor.ABGR32.m_266446_((int)baseColor);
        float baseRed = FastColor.ABGR32.m_266313_((int)baseColor);
        float alph = a * a + baseAlpha * (1.0f - a);
        int finalAlpha = (int)(alph * 255.0f);
        int finalBlue = (int)(blue * a + baseBlue * (1.0f - a));
        int finalGreen = (int)(green * a + baseGreen * (1.0f - a));
        int finalRed = (int)(red * a + baseRed * (1.0f - a));
        if (finalAlpha > 255) {
            finalAlpha = 255;
        }
        if (finalBlue > 255) {
            finalBlue = 255;
        }
        if (finalGreen > 255) {
            finalGreen = 255;
        }
        if (finalRed > 255) {
            finalRed = 255;
        }
        image.m_84988_(x, y, FastColor.ABGR32.m_266248_((int)finalAlpha, (int)finalBlue, (int)finalGreen, (int)finalRed));
    }
}

